/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.web;

import java.util.Map;
import java.util.Objects;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;

public class SpringBootTestRandomPortEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    private static final String MANAGEMENT_PORT_PROPERTY = "management.server.port";
    private static final String SERVER_PORT_PROPERTY = "server.port";

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        String managementPort;
        MapPropertySource source = (MapPropertySource)environment.getPropertySources().get("Inlined Test Properties");
        if (this.isTestServerPortRandom(source) && source.getProperty(MANAGEMENT_PORT_PROPERTY) == null && (managementPort = this.getProperty(environment, MANAGEMENT_PORT_PROPERTY, null)) != null && !managementPort.equals("-1")) {
            String serverPort = this.getProperty(environment, SERVER_PORT_PROPERTY, "8080");
            if (!managementPort.equals(serverPort)) {
                ((Map)source.getSource()).put(MANAGEMENT_PORT_PROPERTY, "0");
            } else {
                ((Map)source.getSource()).put(MANAGEMENT_PORT_PROPERTY, "");
            }
        }
    }

    private boolean isTestServerPortRandom(MapPropertySource source) {
        return source != null && "0".equals(source.getProperty(SERVER_PORT_PROPERTY));
    }

    private String getProperty(ConfigurableEnvironment environment, String property, String defaultValue) {
        return environment.getPropertySources().stream().filter(source -> !source.getName().equals("Inlined Test Properties")).map(source -> (String)source.getProperty(property)).filter(Objects::nonNull).findFirst().orElse(defaultValue);
    }
}

