/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.bind;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.springframework.util.StringUtils;

public final class RelaxedNames
implements Iterable<String> {
    private final String name;

    public RelaxedNames(String name) {
        this.name = name;
    }

    @Override
    public Iterator<String> iterator() {
        return new RelaxedNamesIterator();
    }

    static enum Manipulation {
        NONE{

            @Override
            public String apply(String value) {
                return value;
            }
        }
        ,
        UNDERSCORE{

            @Override
            public String apply(String value) {
                return value.replace("-", "_");
            }
        }
        ,
        CAMELCASE{

            @Override
            public String apply(String value) {
                StringBuilder builder = new StringBuilder();
                for (String field : UNDERSCORE.apply(value).split("_")) {
                    builder.append(builder.length() == 0 ? field : StringUtils.capitalize((String)field));
                }
                return builder.toString();
            }
        };


        public abstract String apply(String var1);
    }

    static enum Variation {
        NONE{

            @Override
            public String apply(String value) {
                return value;
            }
        }
        ,
        LOWERCASE{

            @Override
            public String apply(String value) {
                return value.toLowerCase();
            }
        }
        ,
        UPPERCASE{

            @Override
            public String apply(String value) {
                return value.toUpperCase();
            }
        };


        public abstract String apply(String var1);
    }

    private class RelaxedNamesIterator
    implements Iterator<String> {
        private int variation = 0;
        private int manipulation = 0;

        private RelaxedNamesIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.variation < Variation.values().length;
        }

        @Override
        public String next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String result = RelaxedNames.this.name;
            result = Manipulation.values()[this.manipulation].apply(result);
            result = Variation.values()[this.variation].apply(result);
            ++this.manipulation;
            if (this.manipulation >= Manipulation.values().length) {
                ++this.variation;
                this.manipulation = 0;
            }
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

