/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.embedded.tomcat;

import javax.servlet.ServletException;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.core.StandardContext;
import org.springframework.boot.context.embedded.ServletContextInitializer;
import org.springframework.util.Assert;

public class ServletContextInitializerLifecycleListener
implements LifecycleListener {
    private ServletContextInitializer[] initializers;

    public ServletContextInitializerLifecycleListener(ServletContextInitializer ... initializers) {
        this.initializers = initializers;
    }

    public void lifecycleEvent(LifecycleEvent event) {
        if ("configure_start".equals(event.getType())) {
            Assert.isInstanceOf(StandardContext.class, (Object)event.getSource());
            StandardContext standardContext = (StandardContext)event.getSource();
            for (ServletContextInitializer initializer : this.initializers) {
                try {
                    initializer.onStartup(standardContext.getServletContext());
                }
                catch (ServletException ex) {
                    throw new IllegalStateException(ex);
                }
            }
        }
    }
}

