/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.log4j;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.springframework.boot.logging.AbstractLoggingSystem;
import org.springframework.boot.logging.LogLevel;
import org.springframework.util.Assert;
import org.springframework.util.Log4jConfigurer;
import org.springframework.util.StringUtils;

public class Log4JLoggingSystem
extends AbstractLoggingSystem {
    private static final Map<LogLevel, Level> LEVELS;

    public Log4JLoggingSystem(ClassLoader classLoader) {
        super(classLoader, "log4j.xml", "log4j.properties");
    }

    @Override
    public void initialize(String configLocation) {
        Assert.notNull((Object)configLocation, (String)"ConfigLocation must not be null");
        try {
            Log4jConfigurer.initLogging((String)configLocation);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not initialize logging from " + configLocation, ex);
        }
    }

    @Override
    public void setLogLevel(String loggerName, LogLevel level) {
        Logger logger = StringUtils.hasLength((String)loggerName) ? LogManager.getLogger((String)loggerName) : LogManager.getRootLogger();
        logger.setLevel(LEVELS.get((Object)level));
    }

    static {
        HashMap<LogLevel, Level> levels = new HashMap<LogLevel, Level>();
        levels.put(LogLevel.TRACE, Level.TRACE);
        levels.put(LogLevel.DEBUG, Level.DEBUG);
        levels.put(LogLevel.INFO, Level.INFO);
        levels.put(LogLevel.WARN, Level.WARN);
        levels.put(LogLevel.ERROR, Level.ERROR);
        levels.put(LogLevel.FATAL, Level.ERROR);
        LEVELS = Collections.unmodifiableMap(levels);
    }
}

