/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot;

import java.util.ArrayList;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.springframework.boot.OutputCapture;
import org.springframework.boot.SpringApplication;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

@Configuration
public class SimpleMainTests {
    @Rule
    public OutputCapture outputCapture = new OutputCapture();
    private static final String SPRING_STARTUP = "root of context hierarchy";

    @Test(expected=IllegalArgumentException.class)
    public void emptyApplicationContext() throws Exception {
        SpringApplication.main((String[])this.getArgs(new String[0]));
        Assert.assertTrue((boolean)this.getOutput().contains(SPRING_STARTUP));
    }

    @Test
    public void basePackageScan() throws Exception {
        SpringApplication.main((String[])this.getArgs(ClassUtils.getPackageName(this.getClass()) + ".sampleconfig"));
        Assert.assertTrue((boolean)this.getOutput().contains(SPRING_STARTUP));
    }

    @Test
    public void configClassContext() throws Exception {
        SpringApplication.main((String[])this.getArgs(this.getClass().getName()));
        Assert.assertTrue((boolean)this.getOutput().contains(SPRING_STARTUP));
    }

    @Test
    public void xmlContext() throws Exception {
        SpringApplication.main((String[])this.getArgs("org/springframework/boot/sample-beans.xml"));
        Assert.assertTrue((boolean)this.getOutput().contains(SPRING_STARTUP));
    }

    @Test
    public void mixedContext() throws Exception {
        SpringApplication.main((String[])this.getArgs(this.getClass().getName(), "org/springframework/boot/sample-beans.xml"));
        Assert.assertTrue((boolean)this.getOutput().contains(SPRING_STARTUP));
    }

    private String[] getArgs(String ... args) {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList("--spring.main.webEnvironment=false", "--spring.main.showBanner=false"));
        if (args.length > 0) {
            list.add("--spring.main.sources=" + StringUtils.arrayToCommaDelimitedString((Object[])args));
        }
        return list.toArray(new String[list.size()]);
    }

    private String getOutput() {
        return this.outputCapture.toString();
    }
}

