/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.config;

import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.boot.config.JsonParser;
import org.springframework.boot.config.SimpleJsonParser;

public class SimpleJsonParserTests {
    private JsonParser parser = this.getParser();

    protected JsonParser getParser() {
        return new SimpleJsonParser();
    }

    @Test
    public void testSimpleMap() {
        Map map = this.parser.parseMap("{\"foo\":\"bar\",\"spam\":1}");
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertEquals((Object)"bar", map.get("foo"));
        Assert.assertEquals((Object)"1", (Object)map.get("spam").toString());
    }

    @Test
    public void testEmptyMap() {
        Map map = this.parser.parseMap("{}");
        Assert.assertEquals((long)0L, (long)map.size());
    }

    @Test
    public void testSimpleList() {
        List list = this.parser.parseList("[\"foo\",\"bar\",1]");
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((Object)"bar", list.get(1));
    }

    @Test
    public void testEmptyList() {
        List list = this.parser.parseList("[]");
        Assert.assertEquals((long)0L, (long)list.size());
    }

    @Test
    public void testListOfMaps() {
        List list = this.parser.parseList("[{\"foo\":\"bar\",\"spam\":1},{\"foo\":\"baz\",\"spam\":2}]");
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((long)2L, (long)((Map)list.get(1)).size());
    }
}

