/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.embedded;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import org.mockito.BDDMockito;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.springframework.boot.context.embedded.AbstractEmbeddedServletContainerFactory;
import org.springframework.boot.context.embedded.EmbeddedServletContainer;
import org.springframework.boot.context.embedded.EmbeddedServletContainerException;
import org.springframework.boot.context.embedded.ServletContextInitializer;

public class MockEmbeddedServletContainerFactory
extends AbstractEmbeddedServletContainerFactory {
    private MockEmbeddedServletContainer container;

    public EmbeddedServletContainer getEmbeddedServletContainer(ServletContextInitializer ... initializers) {
        this.container = (MockEmbeddedServletContainer)Mockito.spy((Object)new MockEmbeddedServletContainer(initializers, this.getPort()));
        return this.container;
    }

    public MockEmbeddedServletContainer getContainer() {
        return this.container;
    }

    public ServletContext getServletContext() {
        return this.getContainer() == null ? null : this.getContainer().servletContext;
    }

    public RegisteredServlet getRegisteredServlet(int index) {
        return this.getContainer() == null ? null : this.getContainer().getRegisteredServlets().get(index);
    }

    public RegisteredFilter getRegisteredFilter(int index) {
        return this.getContainer() == null ? null : this.getContainer().getRegisteredFilters().get(index);
    }

    public static class RegisteredFilter {
        private Filter filter;
        private FilterRegistration.Dynamic registration;

        public RegisteredFilter(Filter filter) {
            this.filter = filter;
            this.registration = (FilterRegistration.Dynamic)Mockito.mock(FilterRegistration.Dynamic.class);
        }

        public FilterRegistration.Dynamic getRegistration() {
            return this.registration;
        }

        public Filter getFilter() {
            return this.filter;
        }
    }

    public static class RegisteredServlet {
        private Servlet servlet;
        private ServletRegistration.Dynamic registration;

        public RegisteredServlet(Servlet servlet) {
            this.servlet = servlet;
            this.registration = (ServletRegistration.Dynamic)Mockito.mock(ServletRegistration.Dynamic.class);
        }

        public ServletRegistration.Dynamic getRegistration() {
            return this.registration;
        }

        public Servlet getServlet() {
            return this.servlet;
        }
    }

    public static class MockEmbeddedServletContainer
    implements EmbeddedServletContainer {
        private ServletContext servletContext;
        private ServletContextInitializer[] initializers;
        private List<RegisteredServlet> registeredServlets = new ArrayList<RegisteredServlet>();
        private List<RegisteredFilter> registeredFilters = new ArrayList<RegisteredFilter>();
        private int port;

        public MockEmbeddedServletContainer(ServletContextInitializer[] initializers, int port) {
            this.initializers = initializers;
            this.port = port;
            this.initialize();
        }

        private void initialize() {
            try {
                this.servletContext = (ServletContext)Mockito.mock(ServletContext.class);
                BDDMockito.given((Object)this.servletContext.addServlet(Matchers.anyString(), (Servlet)Matchers.anyObject())).willAnswer((Answer)new Answer<ServletRegistration.Dynamic>(){

                    public ServletRegistration.Dynamic answer(InvocationOnMock invocation) throws Throwable {
                        RegisteredServlet registeredServlet = new RegisteredServlet((Servlet)invocation.getArguments()[1]);
                        MockEmbeddedServletContainer.this.registeredServlets.add(registeredServlet);
                        return registeredServlet.getRegistration();
                    }
                });
                BDDMockito.given((Object)this.servletContext.addFilter(Matchers.anyString(), (Filter)Matchers.anyObject())).willAnswer((Answer)new Answer<FilterRegistration.Dynamic>(){

                    public FilterRegistration.Dynamic answer(InvocationOnMock invocation) throws Throwable {
                        RegisteredFilter registeredFilter = new RegisteredFilter((Filter)invocation.getArguments()[1]);
                        MockEmbeddedServletContainer.this.registeredFilters.add(registeredFilter);
                        return registeredFilter.getRegistration();
                    }
                });
                BDDMockito.given((Object)this.servletContext.getInitParameterNames()).willReturn(MockEmbeddedServletContainer.emptyEnumeration());
                BDDMockito.given((Object)this.servletContext.getAttributeNames()).willReturn(MockEmbeddedServletContainer.emptyEnumeration());
                BDDMockito.given((Object)this.servletContext.getNamedDispatcher("default")).willReturn(Mockito.mock(RequestDispatcher.class));
                for (ServletContextInitializer initializer : this.initializers) {
                    initializer.onStartup(this.servletContext);
                }
            }
            catch (ServletException ex) {
                throw new RuntimeException(ex);
            }
        }

        public static <T> Enumeration<T> emptyEnumeration() {
            return EmptyEnumeration.EMPTY_ENUMERATION;
        }

        public void start() throws EmbeddedServletContainerException {
        }

        public void stop() {
            this.servletContext = null;
            this.registeredServlets.clear();
        }

        public Servlet[] getServlets() {
            Servlet[] servlets = new Servlet[this.registeredServlets.size()];
            for (int i = 0; i < servlets.length; ++i) {
                servlets[i] = this.registeredServlets.get(i).getServlet();
            }
            return servlets;
        }

        public List<RegisteredServlet> getRegisteredServlets() {
            return this.registeredServlets;
        }

        public List<RegisteredFilter> getRegisteredFilters() {
            return this.registeredFilters;
        }

        public int getPort() {
            return this.port;
        }

        private static class EmptyEnumeration<E>
        implements Enumeration<E> {
            static final EmptyEnumeration<Object> EMPTY_ENUMERATION = new EmptyEnumeration();

            private EmptyEnumeration() {
            }

            @Override
            public boolean hasMoreElements() {
                return false;
            }

            @Override
            public E nextElement() {
                throw new NoSuchElementException();
            }
        }
    }
}

