/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.initializer;

import org.junit.Assert;
import org.junit.Test;
import org.springframework.boot.TestUtils;
import org.springframework.boot.context.initializer.ContextIdApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class ContextIdApplicationContextInitializerTests {
    private ContextIdApplicationContextInitializer initializer = new ContextIdApplicationContextInitializer();

    @Test
    public void testDefaults() {
        AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext();
        this.initializer.initialize((ConfigurableApplicationContext)context);
        Assert.assertEquals((Object)"application", (Object)context.getId());
    }

    @Test
    public void testNameAndPort() {
        AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext();
        TestUtils.addEnviroment((ConfigurableApplicationContext)context, "spring.application.name:foo", "PORT:8080");
        this.initializer.initialize((ConfigurableApplicationContext)context);
        Assert.assertEquals((Object)"foo:8080", (Object)context.getId());
    }

    @Test
    public void testNameAndProfiles() {
        AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext();
        TestUtils.addEnviroment((ConfigurableApplicationContext)context, "spring.application.name:foo", "spring.profiles.active: spam,bar");
        this.initializer.initialize((ConfigurableApplicationContext)context);
        Assert.assertEquals((Object)"foo:spam,bar", (Object)context.getId());
    }

    @Test
    public void testCloudFoundry() {
        AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext();
        TestUtils.addEnviroment((ConfigurableApplicationContext)context, "spring.config.name:foo", "PORT:8080", "vcap.application.name:bar", "vcap.application.instance_index:2");
        this.initializer.initialize((ConfigurableApplicationContext)context);
        Assert.assertEquals((Object)"bar:2", (Object)context.getId());
    }

    @Test
    public void testExplicitName() {
        AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext();
        TestUtils.addEnviroment((ConfigurableApplicationContext)context, "spring.application.name:spam", "spring.config.name:foo", "PORT:8080", "vcap.application.application_name:bar", "vcap.application.instance_index:2");
        this.initializer.initialize((ConfigurableApplicationContext)context);
        Assert.assertEquals((Object)"spam:2", (Object)context.getId());
    }
}

