/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.liquibase;

import java.lang.reflect.Field;
import liquibase.servicelocator.ServiceLocator;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.liquibase.SpringPackageScanClassResolver;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.ReflectionUtils;

public class LiquibaseServiceLocatorInitializerTests {
    @Test
    public void replacesServiceLocator() throws Exception {
        SpringApplication application = new SpringApplication(new Object[]{Conf.class});
        application.setWebEnvironment(false);
        application.run(new String[0]);
        ServiceLocator instance = ServiceLocator.getInstance();
        Field field = ReflectionUtils.findField(ServiceLocator.class, (String)"classResolver");
        field.setAccessible(true);
        Object resolver = field.get(instance);
        Assert.assertThat((Object)resolver, (Matcher)Matchers.instanceOf(SpringPackageScanClassResolver.class));
    }

    @Configuration
    public static class Conf {
    }
}

