/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggingEvent;
import java.util.Collections;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.boot.ansi.AnsiOutput;
import org.springframework.boot.logging.logback.ColorConverter;

public class ColorConverterTests {
    private ColorConverter converter;
    private LoggingEvent event;
    private String in = "in";

    @BeforeClass
    public static void setupAnsi() {
        AnsiOutput.setEnabled((AnsiOutput.Enabled)AnsiOutput.Enabled.ALWAYS);
    }

    @AfterClass
    public static void resetAnsi() {
        AnsiOutput.setEnabled((AnsiOutput.Enabled)AnsiOutput.Enabled.DETECT);
    }

    @Before
    public void setup() {
        this.converter = new ColorConverter();
        this.event = new LoggingEvent();
    }

    @Test
    public void faint() throws Exception {
        this.converter.setOptionList(Collections.singletonList("faint"));
        String out = this.converter.transform((ILoggingEvent)this.event, this.in);
        Assert.assertThat((Object)out, (Matcher)Matchers.equalTo((Object)"\u001b[2min\u001b[0;39m"));
    }

    @Test
    public void red() throws Exception {
        this.converter.setOptionList(Collections.singletonList("red"));
        String out = this.converter.transform((ILoggingEvent)this.event, this.in);
        Assert.assertThat((Object)out, (Matcher)Matchers.equalTo((Object)"\u001b[31min\u001b[0;39m"));
    }

    @Test
    public void green() throws Exception {
        this.converter.setOptionList(Collections.singletonList("green"));
        String out = this.converter.transform((ILoggingEvent)this.event, this.in);
        Assert.assertThat((Object)out, (Matcher)Matchers.equalTo((Object)"\u001b[32min\u001b[0;39m"));
    }

    @Test
    public void yellow() throws Exception {
        this.converter.setOptionList(Collections.singletonList("yellow"));
        String out = this.converter.transform((ILoggingEvent)this.event, this.in);
        Assert.assertThat((Object)out, (Matcher)Matchers.equalTo((Object)"\u001b[33min\u001b[0;39m"));
    }

    @Test
    public void blue() throws Exception {
        this.converter.setOptionList(Collections.singletonList("blue"));
        String out = this.converter.transform((ILoggingEvent)this.event, this.in);
        Assert.assertThat((Object)out, (Matcher)Matchers.equalTo((Object)"\u001b[34min\u001b[0;39m"));
    }

    @Test
    public void magenta() throws Exception {
        this.converter.setOptionList(Collections.singletonList("magenta"));
        String out = this.converter.transform((ILoggingEvent)this.event, this.in);
        Assert.assertThat((Object)out, (Matcher)Matchers.equalTo((Object)"\u001b[35min\u001b[0;39m"));
    }

    @Test
    public void cyan() throws Exception {
        this.converter.setOptionList(Collections.singletonList("cyan"));
        String out = this.converter.transform((ILoggingEvent)this.event, this.in);
        Assert.assertThat((Object)out, (Matcher)Matchers.equalTo((Object)"\u001b[36min\u001b[0;39m"));
    }

    @Test
    public void highlightError() throws Exception {
        this.event.setLevel(Level.ERROR);
        String out = this.converter.transform((ILoggingEvent)this.event, this.in);
        Assert.assertThat((Object)out, (Matcher)Matchers.equalTo((Object)"\u001b[31min\u001b[0;39m"));
    }

    @Test
    public void highlightWarn() throws Exception {
        this.event.setLevel(Level.WARN);
        String out = this.converter.transform((ILoggingEvent)this.event, this.in);
        Assert.assertThat((Object)out, (Matcher)Matchers.equalTo((Object)"\u001b[33min\u001b[0;39m"));
    }

    @Test
    public void highlightDebug() throws Exception {
        this.event.setLevel(Level.DEBUG);
        String out = this.converter.transform((ILoggingEvent)this.event, this.in);
        Assert.assertThat((Object)out, (Matcher)Matchers.equalTo((Object)"\u001b[32min\u001b[0;39m"));
    }

    @Test
    public void highlightTrace() throws Exception {
        this.event.setLevel(Level.TRACE);
        String out = this.converter.transform((ILoggingEvent)this.event, this.in);
        Assert.assertThat((Object)out, (Matcher)Matchers.equalTo((Object)"\u001b[32min\u001b[0;39m"));
    }
}

