/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.logback;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.SLF4JLogFactory;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.springframework.boot.OutputCapture;
import org.springframework.boot.logging.LogLevel;
import org.springframework.boot.logging.logback.LogbackLoggingSystem;
import org.springframework.util.StringUtils;

public class LogbackLoggingSystemTests {
    @Rule
    public OutputCapture output = new OutputCapture();
    private LogbackLoggingSystem loggingSystem = new LogbackLoggingSystem(this.getClass().getClassLoader());
    private Log logger;

    @Before
    public void setup() {
        this.logger = new SLF4JLogFactory().getInstance(this.getClass().getName());
    }

    @After
    public void clear() {
        System.clearProperty("LOG_FILE");
        System.clearProperty("LOG_PATH");
        System.clearProperty("PID");
    }

    @Test
    public void testNonDefaultConfigLocation() throws Exception {
        this.loggingSystem.initialize("classpath:logback-nondefault.xml");
        this.logger.info((Object)"Hello world");
        String output = this.output.toString().trim();
        Assert.assertTrue((String)("Wrong output:\n" + output), (boolean)output.contains("Hello world"));
        Assert.assertTrue((String)("Wrong output:\n" + output), (boolean)output.contains("/tmp/spring.log"));
    }

    @Test(expected=IllegalStateException.class)
    public void testNonexistentConfigLocation() throws Exception {
        this.loggingSystem.initialize("classpath:logback-nonexistent.xml");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullConfigLocation() throws Exception {
        this.loggingSystem.initialize(null);
    }

    @Test
    public void setLevel() throws Exception {
        this.loggingSystem.initialize();
        this.logger.debug((Object)"Hello");
        this.loggingSystem.setLogLevel("org.springframework.boot", LogLevel.DEBUG);
        this.logger.debug((Object)"Hello");
        Assert.assertThat((Object)StringUtils.countOccurrencesOf((String)this.output.toString(), (String)"Hello"), (Matcher)Matchers.equalTo((Object)1));
    }
}

