/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import javax.servlet.ServletContext;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.initializer.ServletContextApplicationContextInitializer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.mock.web.MockServletContext;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.support.AbstractContextLoader;
import org.springframework.test.context.web.WebMergedContextConfiguration;
import org.springframework.util.ObjectUtils;
import org.springframework.web.context.support.GenericWebApplicationContext;

public class SpringApplicationContextLoader
extends AbstractContextLoader {
    public ApplicationContext loadContext(MergedContextConfiguration mergedConfig) throws Exception {
        LinkedHashSet<Object> sources = new LinkedHashSet<Object>();
        sources.addAll(Arrays.asList(mergedConfig.getClasses()));
        sources.addAll(Arrays.asList(mergedConfig.getLocations()));
        SpringApplication application = new SpringApplication(new Object[0]);
        application.setSources(sources);
        LinkedHashMap<String, String> args = new LinkedHashMap<String, String>();
        if (!ObjectUtils.isEmpty((Object[])mergedConfig.getActiveProfiles())) {
            application.setAdditionalProfiles(Arrays.asList(mergedConfig.getActiveProfiles()));
        }
        args.put("server.port", "0");
        args.put("management.port", "0");
        application.setDefaultProperties(args);
        ArrayList initializers = new ArrayList(application.getInitializers());
        for (Class type : mergedConfig.getContextInitializerClasses()) {
            initializers.add((ApplicationContextInitializer<?>)BeanUtils.instantiate((Class)type));
        }
        if (mergedConfig instanceof WebMergedContextConfiguration) {
            new WebConfigurer().setup(mergedConfig, application, initializers);
        } else {
            application.setWebEnvironment(false);
        }
        application.setInitializers(initializers);
        return application.run(new String[0]);
    }

    public ApplicationContext loadContext(String ... locations) throws Exception {
        throw new UnsupportedOperationException("SpringApplicationContextLoader does not support the loadContext(String...) method");
    }

    protected String getResourceSuffix() {
        return "-context.xml";
    }

    private static class WebConfigurer {
        private WebConfigurer() {
        }

        void setup(MergedContextConfiguration mergedConfig, SpringApplication application, List<ApplicationContextInitializer<?>> initializers) {
            WebMergedContextConfiguration webConfig = (WebMergedContextConfiguration)mergedConfig;
            MockServletContext servletContext = new MockServletContext(webConfig.getResourceBasePath());
            initializers.add(0, (ApplicationContextInitializer<?>)new ServletContextApplicationContextInitializer((ServletContext)servletContext));
            application.setApplicationContextClass(GenericWebApplicationContext.class);
        }
    }
}

