/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.embedded.jetty;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.springframework.boot.context.embedded.EmbeddedServletContainer;
import org.springframework.boot.context.embedded.EmbeddedServletContainerException;
import org.springframework.util.Assert;

public class JettyEmbeddedServletContainer
implements EmbeddedServletContainer {
    private final Log logger = LogFactory.getLog(JettyEmbeddedServletContainer.class);
    private final Server server;
    private boolean autoStart;

    public JettyEmbeddedServletContainer(Server server) {
        this(server, true);
    }

    public JettyEmbeddedServletContainer(Server server, boolean autoStart) {
        this.autoStart = autoStart;
        Assert.notNull((Object)server, (String)"Jetty Server must not be null");
        this.server = server;
        this.initialize();
    }

    private synchronized void initialize() {
        try {
            Connector[] connectors;
            this.server.start();
            for (Connector connector : connectors = this.server.getConnectors()) {
                connector.stop();
            }
        }
        catch (Exception ex) {
            throw new EmbeddedServletContainerException("Unable to start embedded Jetty servlet container", ex);
        }
    }

    @Override
    public void start() throws EmbeddedServletContainerException {
        if (!this.autoStart) {
            return;
        }
        try {
            Connector[] connectors;
            this.server.start();
            for (Connector connector : connectors = this.server.getConnectors()) {
                connector.start();
                this.logger.info((Object)("Jetty started on port: " + connector.getLocalPort()));
            }
        }
        catch (Exception ex) {
            throw new EmbeddedServletContainerException("Unable to start embedded Jetty servlet container", ex);
        }
    }

    @Override
    public synchronized void stop() {
        try {
            this.server.stop();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        catch (Exception ex) {
            throw new EmbeddedServletContainerException("Unable to stop embedded Jetty servlet container", ex);
        }
    }

    @Override
    public int getPort() {
        int i$ = 0;
        Connector[] connectors = this.server.getConnectors();
        Connector[] arr$ = connectors;
        int len$ = arr$.length;
        if (i$ < len$) {
            Connector connector = arr$[i$];
            return connector.getLocalPort();
        }
        return 0;
    }

    public Server getServer() {
        return this.server;
    }
}

