/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.config;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.yaml.snakeyaml.Yaml;

public class YamlProcessor {
    private final Log logger = LogFactory.getLog(this.getClass());
    private ResolutionMethod resolutionMethod = ResolutionMethod.OVERRIDE;
    private Resource[] resources = new Resource[0];
    private List<DocumentMatcher> documentMatchers = Collections.emptyList();
    private boolean matchDefault = true;

    public void setDocumentMatchers(List<? extends DocumentMatcher> matchers) {
        this.documentMatchers = Collections.unmodifiableList(matchers);
    }

    public void setMatchDefault(boolean matchDefault) {
        this.matchDefault = matchDefault;
    }

    public void setResolutionMethod(ResolutionMethod resolutionMethod) {
        Assert.notNull((Object)((Object)resolutionMethod), (String)"ResolutionMethod must not be null");
        this.resolutionMethod = resolutionMethod;
    }

    public void setResources(Resource[] resources) {
        this.resources = resources == null ? null : (Resource[])resources.clone();
    }

    protected void process(MatchCallback callback) {
        Yaml yaml = new Yaml();
        for (Resource resource : this.resources) {
            boolean found = this.process(callback, yaml, resource);
            if (this.resolutionMethod != ResolutionMethod.FIRST_FOUND || !found) continue;
            return;
        }
    }

    private boolean process(MatchCallback callback, Yaml yaml, Resource resource) {
        int count = 0;
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Loading from YAML: " + resource));
            }
            for (Object object : yaml.loadAll(resource.getInputStream())) {
                if (object == null || !this.process(this.asMap(object), callback)) continue;
                ++count;
                if (this.resolutionMethod != ResolutionMethod.FIRST_FOUND) continue;
                break;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Loaded " + count + " document" + (count > 1 ? "s" : "") + " from YAML resource: " + resource));
            }
        }
        catch (IOException ex) {
            this.handleProcessError(resource, ex);
        }
        return count > 0;
    }

    private void handleProcessError(Resource resource, IOException ex) {
        if (this.resolutionMethod != ResolutionMethod.FIRST_FOUND && this.resolutionMethod != ResolutionMethod.OVERRIDE_AND_IGNORE) {
            throw new IllegalStateException(ex);
        }
        if (this.logger.isWarnEnabled()) {
            this.logger.warn((Object)("Could not load map from " + resource + ": " + ex.getMessage()));
        }
    }

    private Map<String, Object> asMap(Object object) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if (!(object instanceof Map)) {
            result.put("document", object);
            return result;
        }
        Map map = (Map)object;
        for (Map.Entry entry : map.entrySet()) {
            Object key;
            Object value = entry.getValue();
            if (value instanceof Map) {
                value = this.asMap(value);
            }
            if ((key = entry.getKey()) instanceof CharSequence) {
                result.put(key.toString(), value);
                continue;
            }
            result.put("[" + key.toString() + "]", value);
        }
        return result;
    }

    private boolean process(Map<String, Object> map, MatchCallback callback) {
        Properties properties = new Properties();
        this.assignProperties(properties, map, null);
        if (this.documentMatchers.isEmpty()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Merging document (no matchers set)" + map));
            }
            callback.process(properties, map);
        } else {
            boolean valueFound = false;
            MatchStatus result = MatchStatus.ABSTAIN;
            for (DocumentMatcher matcher : this.documentMatchers) {
                MatchStatus match = matcher.matches(properties);
                result = MatchStatus.getMostSpecific(match, result);
                if (match != MatchStatus.FOUND) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Matched document with document matcher: " + properties));
                }
                callback.process(properties, map);
                valueFound = true;
                break;
            }
            if (result == MatchStatus.ABSTAIN && this.matchDefault) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Matched document with default matcher: " + map));
                }
                callback.process(properties, map);
            } else if (!valueFound) {
                this.logger.debug((Object)"Unmatched document");
                return false;
            }
        }
        return true;
    }

    private void assignProperties(Properties properties, Map<String, Object> input, String path) {
        for (Map.Entry<String, Object> entry : input.entrySet()) {
            Object value;
            String key = entry.getKey();
            if (StringUtils.hasText((String)path)) {
                key = key.startsWith("[") ? path + key : path + "." + key;
            }
            if ((value = entry.getValue()) instanceof String) {
                properties.put(key, value);
                continue;
            }
            if (value instanceof Map) {
                Map map = (Map)value;
                this.assignProperties(properties, map, key);
                continue;
            }
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                int count = 0;
                for (Object object : collection) {
                    this.assignProperties(properties, Collections.singletonMap("[" + count++ + "]", object), key);
                }
                continue;
            }
            properties.put(key, value == null ? "" : value);
        }
    }

    public static enum ResolutionMethod {
        OVERRIDE,
        OVERRIDE_AND_IGNORE,
        FIRST_FOUND;

    }

    public static enum MatchStatus {
        FOUND,
        NOT_FOUND,
        ABSTAIN;


        public static MatchStatus getMostSpecific(MatchStatus a, MatchStatus b) {
            return a.ordinal() < b.ordinal() ? a : b;
        }
    }

    public static interface DocumentMatcher {
        public MatchStatus matches(Properties var1);
    }

    public static interface MatchCallback {
        public void process(Properties var1, Map<String, Object> var2);
    }
}

