/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.BeanDefinitionLoader;
import org.springframework.boot.sampleconfig.MyComponent;
import org.springframework.context.support.StaticApplicationContext;
import org.springframework.core.io.ClassPathResource;

public class BeanDefinitionLoaderTests {
    private StaticApplicationContext registry;

    @Before
    public void setup() {
        this.registry = new StaticApplicationContext();
    }

    @Test
    public void loadClass() throws Exception {
        BeanDefinitionLoader loader = new BeanDefinitionLoader((BeanDefinitionRegistry)this.registry, new Object[]{MyComponent.class});
        int loaded = loader.load();
        Assert.assertThat((Object)loaded, (Matcher)Matchers.equalTo((Object)1));
        Assert.assertTrue((boolean)this.registry.containsBean("myComponent"));
    }

    @Test
    public void loadXmlResource() throws Exception {
        ClassPathResource resource = new ClassPathResource("sample-beans.xml", this.getClass());
        BeanDefinitionLoader loader = new BeanDefinitionLoader((BeanDefinitionRegistry)this.registry, new Object[]{resource});
        int loaded = loader.load();
        Assert.assertThat((Object)loaded, (Matcher)Matchers.equalTo((Object)1));
        Assert.assertTrue((boolean)this.registry.containsBean("myXmlComponent"));
    }

    @Test
    public void loadGroovyResource() throws Exception {
        ClassPathResource resource = new ClassPathResource("sample-beans.groovy", this.getClass());
        BeanDefinitionLoader loader = new BeanDefinitionLoader((BeanDefinitionRegistry)this.registry, new Object[]{resource});
        int loaded = loader.load();
        Assert.assertThat((Object)loaded, (Matcher)Matchers.equalTo((Object)1));
        Assert.assertTrue((boolean)this.registry.containsBean("myGroovyComponent"));
    }

    @Test
    public void loadGroovyResourceWithNamespace() throws Exception {
        ClassPathResource resource = new ClassPathResource("sample-namespace.groovy", this.getClass());
        BeanDefinitionLoader loader = new BeanDefinitionLoader((BeanDefinitionRegistry)this.registry, new Object[]{resource});
        int loaded = loader.load();
        Assert.assertThat((Object)loaded, (Matcher)Matchers.equalTo((Object)1));
        Assert.assertTrue((boolean)this.registry.containsBean("myGroovyComponent"));
    }

    @Test
    public void loadPackage() throws Exception {
        BeanDefinitionLoader loader = new BeanDefinitionLoader((BeanDefinitionRegistry)this.registry, new Object[]{MyComponent.class.getPackage()});
        int loaded = loader.load();
        Assert.assertThat((Object)loaded, (Matcher)Matchers.equalTo((Object)1));
        Assert.assertTrue((boolean)this.registry.containsBean("myComponent"));
    }

    @Test
    public void loadClassName() throws Exception {
        BeanDefinitionLoader loader = new BeanDefinitionLoader((BeanDefinitionRegistry)this.registry, new Object[]{MyComponent.class.getName()});
        int loaded = loader.load();
        Assert.assertThat((Object)loaded, (Matcher)Matchers.equalTo((Object)1));
        Assert.assertTrue((boolean)this.registry.containsBean("myComponent"));
    }

    @Test
    public void loadResourceName() throws Exception {
        BeanDefinitionLoader loader = new BeanDefinitionLoader((BeanDefinitionRegistry)this.registry, new Object[]{"classpath:org/springframework/boot/sample-beans.xml"});
        int loaded = loader.load();
        Assert.assertThat((Object)loaded, (Matcher)Matchers.equalTo((Object)1));
        Assert.assertTrue((boolean)this.registry.containsBean("myXmlComponent"));
    }

    @Test
    public void loadGroovyName() throws Exception {
        BeanDefinitionLoader loader = new BeanDefinitionLoader((BeanDefinitionRegistry)this.registry, new Object[]{"classpath:org/springframework/boot/sample-beans.groovy"});
        int loaded = loader.load();
        Assert.assertThat((Object)loaded, (Matcher)Matchers.equalTo((Object)1));
        Assert.assertTrue((boolean)this.registry.containsBean("myGroovyComponent"));
    }

    @Test
    public void loadPackageName() throws Exception {
        BeanDefinitionLoader loader = new BeanDefinitionLoader((BeanDefinitionRegistry)this.registry, new Object[]{MyComponent.class.getPackage().getName()});
        int loaded = loader.load();
        Assert.assertThat((Object)loaded, (Matcher)Matchers.equalTo((Object)1));
        Assert.assertTrue((boolean)this.registry.containsBean("myComponent"));
    }

    @Test
    public void loadPackageAndClassDoesNotDoubleAdd() throws Exception {
        BeanDefinitionLoader loader = new BeanDefinitionLoader((BeanDefinitionRegistry)this.registry, new Object[]{MyComponent.class.getPackage(), MyComponent.class});
        int loaded = loader.load();
        Assert.assertThat((Object)loaded, (Matcher)Matchers.equalTo((Object)1));
        Assert.assertTrue((boolean)this.registry.containsBean("myComponent"));
    }
}

