/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Configuration;

public class ReproTests {
    @Test
    public void enableProfileViaApplicationProperties() throws Exception {
        SpringApplication application = new SpringApplication(new Object[]{Config.class});
        application.setWebEnvironment(false);
        ConfigurableApplicationContext context = application.run(new String[]{"--spring.config.name=enableprofileviaapplicationproperties", "--spring.profiles.active=dev"});
        Assert.assertThat((Object)context.getEnvironment().acceptsProfiles(new String[]{"dev"}), (Matcher)Matchers.equalTo((Object)true));
        Assert.assertThat((Object)context.getEnvironment().acceptsProfiles(new String[]{"a"}), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void activeProfilesWithYamlAndCommandLine() throws Exception {
        SpringApplication application = new SpringApplication(new Object[]{Config.class});
        application.setWebEnvironment(false);
        String configName = "--spring.config.name=activeprofilerepro";
        this.assertVersionProperty(application.run(new String[]{configName, "--spring.profiles.active=B"}), "B", "B");
    }

    @Test
    public void activeProfilesWithYamlOnly() throws Exception {
        SpringApplication application = new SpringApplication(new Object[]{Config.class});
        application.setWebEnvironment(false);
        String configName = "--spring.config.name=activeprofilerepro";
        this.assertVersionProperty(application.run(new String[]{configName}), "B", "B");
    }

    @Test
    public void orderActiveProfilesWithYamlOnly() throws Exception {
        SpringApplication application = new SpringApplication(new Object[]{Config.class});
        application.setWebEnvironment(false);
        String configName = "--spring.config.name=activeprofilerepro-ordered";
        this.assertVersionProperty(application.run(new String[]{configName}), "B", "A", "B");
    }

    @Test
    public void commandLineBeatsProfilesWithYaml() throws Exception {
        SpringApplication application = new SpringApplication(new Object[]{Config.class});
        application.setWebEnvironment(false);
        String configName = "--spring.config.name=activeprofilerepro";
        this.assertVersionProperty(application.run(new String[]{configName, "--spring.profiles.active=C"}), "C", "C");
    }

    @Test
    public void orderProfilesWithYaml() throws Exception {
        SpringApplication application = new SpringApplication(new Object[]{Config.class});
        application.setWebEnvironment(false);
        String configName = "--spring.config.name=activeprofilerepro";
        this.assertVersionProperty(application.run(new String[]{configName, "--spring.profiles.active=A,C"}), "C", "A", "C");
    }

    @Test
    public void reverseOrderOfProfilesWithYaml() throws Exception {
        SpringApplication application = new SpringApplication(new Object[]{Config.class});
        application.setWebEnvironment(false);
        String configName = "--spring.config.name=activeprofilerepro";
        this.assertVersionProperty(application.run(new String[]{configName, "--spring.profiles.active=C,A"}), "A", "C", "A");
    }

    @Test
    public void activeProfilesWithYamlAndCommandLineAndNoOverride() throws Exception {
        SpringApplication application = new SpringApplication(new Object[]{Config.class});
        application.setWebEnvironment(false);
        String configName = "--spring.config.name=activeprofilerepro-without-override";
        this.assertVersionProperty(application.run(new String[]{configName, "--spring.profiles.active=B"}), "B", "B");
    }

    @Test
    public void activeProfilesWithYamlOnlyAndNoOverride() throws Exception {
        SpringApplication application = new SpringApplication(new Object[]{Config.class});
        application.setWebEnvironment(false);
        String configName = "--spring.config.name=activeprofilerepro-without-override";
        this.assertVersionProperty(application.run(new String[]{configName}), null, new String[0]);
    }

    @Test
    public void commandLineBeatsProfilesWithYamlAndNoOverride() throws Exception {
        SpringApplication application = new SpringApplication(new Object[]{Config.class});
        application.setWebEnvironment(false);
        String configName = "--spring.config.name=activeprofilerepro-without-override";
        this.assertVersionProperty(application.run(new String[]{configName, "--spring.profiles.active=C"}), "C", "C");
    }

    @Test
    public void orderProfilesWithYamlAndNoOverride() throws Exception {
        SpringApplication application = new SpringApplication(new Object[]{Config.class});
        application.setWebEnvironment(false);
        String configName = "--spring.config.name=activeprofilerepro-without-override";
        this.assertVersionProperty(application.run(new String[]{configName, "--spring.profiles.active=A,C"}), "C", "A", "C");
    }

    @Test
    public void reverseOrderOfProfilesWithYamlAndNoOverride() throws Exception {
        SpringApplication application = new SpringApplication(new Object[]{Config.class});
        application.setWebEnvironment(false);
        String configName = "--spring.config.name=activeprofilerepro-without-override";
        this.assertVersionProperty(application.run(new String[]{configName, "--spring.profiles.active=C,A"}), "A", "C", "A");
    }

    private void assertVersionProperty(ConfigurableApplicationContext context, String expectedVersion, String ... expectedActiveProfiles) {
        Assert.assertThat((Object)context.getEnvironment().getActiveProfiles(), (Matcher)Matchers.equalTo((Object)expectedActiveProfiles));
        Assert.assertThat((String)"version mismatch", (Object)context.getEnvironment().getProperty("version"), (Matcher)Matchers.equalTo((Object)expectedVersion));
        context.close();
    }

    @Configuration
    public static class Config {
    }
}

