/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.validation.constraints.NotNull;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.test.EnvironmentTestUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportResource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.stereotype.Component;
import org.springframework.validation.BindException;

public class EnableConfigurationPropertiesTests {
    private final AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext();
    @Rule
    public ExpectedException expected = ExpectedException.none();

    @After
    public void close() {
        System.clearProperty("name");
        System.clearProperty("nested.name");
        System.clearProperty("nested_name");
    }

    @Test
    public void testBasicPropertiesBinding() {
        this.context.register(new Class[]{TestConfiguration.class});
        EnvironmentTestUtils.addEnvironment((ConfigurableApplicationContext)this.context, (String[])new String[]{"name:foo"});
        this.context.refresh();
        Assert.assertEquals((long)1L, (long)this.context.getBeanNamesForType(TestProperties.class).length);
        Assert.assertEquals((Object)"foo", (Object)((TestProperties)this.context.getBean(TestProperties.class)).name);
    }

    @Test
    public void testSystemPropertiesBinding() {
        this.context.register(new Class[]{TestConfiguration.class});
        System.setProperty("name", "foo");
        this.context.refresh();
        Assert.assertEquals((long)1L, (long)this.context.getBeanNamesForType(TestProperties.class).length);
        Assert.assertEquals((Object)"foo", (Object)((TestProperties)this.context.getBean(TestProperties.class)).name);
    }

    @Test
    public void testNestedSystemPropertiesBinding() {
        this.context.register(new Class[]{NestedConfiguration.class});
        System.setProperty("name", "foo");
        System.setProperty("nested.name", "bar");
        this.context.refresh();
        Assert.assertEquals((long)1L, (long)this.context.getBeanNamesForType(NestedProperties.class).length);
        Assert.assertEquals((Object)"foo", (Object)((NestedProperties)this.context.getBean(NestedProperties.class)).name);
        Assert.assertEquals((Object)"bar", (Object)((NestedProperties)this.context.getBean(NestedProperties.class)).nested.name);
    }

    @Test
    public void testNestedSystemPropertiesBindingWithUnderscore() {
        this.context.register(new Class[]{NestedConfiguration.class});
        System.setProperty("name", "foo");
        System.setProperty("nested_name", "bar");
        this.context.refresh();
        Assert.assertEquals((long)1L, (long)this.context.getBeanNamesForType(NestedProperties.class).length);
        Assert.assertEquals((Object)"foo", (Object)((NestedProperties)this.context.getBean(NestedProperties.class)).name);
        Assert.assertEquals((Object)"bar", (Object)((NestedProperties)this.context.getBean(NestedProperties.class)).nested.name);
    }

    @Test
    public void testNestedOsEnvironmentVariableWithUnderscore() {
        EnvironmentTestUtils.addEnvironment((ConfigurableApplicationContext)this.context, (String[])new String[]{"NAME:foo", "NESTED_NAME:bar"});
        this.context.register(new Class[]{NestedConfiguration.class});
        this.context.refresh();
        Assert.assertEquals((long)1L, (long)this.context.getBeanNamesForType(NestedProperties.class).length);
        Assert.assertEquals((Object)"foo", (Object)((NestedProperties)this.context.getBean(NestedProperties.class)).name);
        Assert.assertEquals((Object)"bar", (Object)((NestedProperties)this.context.getBean(NestedProperties.class)).nested.name);
    }

    @Test
    public void testStrictPropertiesBinding() {
        this.removeSystemProperties();
        this.context.register(new Class[]{StrictTestConfiguration.class});
        EnvironmentTestUtils.addEnvironment((ConfigurableApplicationContext)this.context, (String[])new String[]{"name:foo"});
        this.context.refresh();
        Assert.assertEquals((long)1L, (long)this.context.getBeanNamesForType(StrictTestProperties.class).length);
        Assert.assertEquals((Object)"foo", (Object)((TestProperties)this.context.getBean(TestProperties.class)).name);
    }

    @Test
    public void testPropertiesEmbeddedBinding() {
        this.context.register(new Class[]{EmbeddedTestConfiguration.class});
        EnvironmentTestUtils.addEnvironment((ConfigurableApplicationContext)this.context, (String[])new String[]{"spring_foo_name:foo"});
        this.context.refresh();
        Assert.assertEquals((long)1L, (long)this.context.getBeanNamesForType(EmbeddedTestProperties.class).length);
        Assert.assertEquals((Object)"foo", (Object)((TestProperties)this.context.getBean(TestProperties.class)).name);
    }

    @Test
    public void testOsEnvironmentVariableEmbeddedBinding() {
        EnvironmentTestUtils.addEnvironment((ConfigurableApplicationContext)this.context, (String[])new String[]{"SPRING_FOO_NAME:foo"});
        this.context.register(new Class[]{EmbeddedTestConfiguration.class});
        this.context.refresh();
        Assert.assertEquals((long)1L, (long)this.context.getBeanNamesForType(EmbeddedTestProperties.class).length);
        Assert.assertEquals((Object)"foo", (Object)((TestProperties)this.context.getBean(TestProperties.class)).name);
    }

    @Test
    public void testIgnoreNestedPropertiesBinding() {
        this.removeSystemProperties();
        this.context.register(new Class[]{IgnoreNestedTestConfiguration.class});
        EnvironmentTestUtils.addEnvironment((ConfigurableApplicationContext)this.context, (String[])new String[]{"name:foo", "nested.name:bar"});
        this.context.refresh();
        Assert.assertEquals((long)1L, (long)this.context.getBeanNamesForType(IgnoreNestedTestProperties.class).length);
        Assert.assertEquals((Object)"foo", (Object)((TestProperties)this.context.getBean(TestProperties.class)).name);
    }

    @Test
    public void testExceptionOnValidation() {
        this.context.register(new Class[]{ExceptionIfInvalidTestConfiguration.class});
        EnvironmentTestUtils.addEnvironment((ConfigurableApplicationContext)this.context, (String[])new String[]{"name:foo"});
        this.expected.expectCause(Matchers.instanceOf(BindException.class));
        this.context.refresh();
    }

    @Test
    public void testNoExceptionOnValidation() {
        this.context.register(new Class[]{NoExceptionIfInvalidTestConfiguration.class});
        EnvironmentTestUtils.addEnvironment((ConfigurableApplicationContext)this.context, (String[])new String[]{"name:foo"});
        this.context.refresh();
        Assert.assertEquals((long)1L, (long)this.context.getBeanNamesForType(NoExceptionIfInvalidTestProperties.class).length);
        Assert.assertEquals((Object)"foo", (Object)((TestProperties)this.context.getBean(TestProperties.class)).name);
    }

    @Test
    public void testNestedPropertiesBinding() {
        this.context.register(new Class[]{NestedConfiguration.class});
        EnvironmentTestUtils.addEnvironment((ConfigurableApplicationContext)this.context, (String[])new String[]{"name:foo", "nested.name:bar"});
        this.context.refresh();
        Assert.assertEquals((long)1L, (long)this.context.getBeanNamesForType(NestedProperties.class).length);
        Assert.assertEquals((Object)"foo", (Object)((NestedProperties)this.context.getBean(NestedProperties.class)).name);
        Assert.assertEquals((Object)"bar", (Object)((NestedProperties)this.context.getBean(NestedProperties.class)).nested.name);
    }

    @Test
    public void testBasicPropertiesBindingWithAnnotationOnBaseClass() {
        this.context.register(new Class[]{DerivedConfiguration.class});
        EnvironmentTestUtils.addEnvironment((ConfigurableApplicationContext)this.context, (String[])new String[]{"name:foo"});
        this.context.refresh();
        Assert.assertEquals((long)1L, (long)this.context.getBeanNamesForType(DerivedProperties.class).length);
        Assert.assertEquals((Object)"foo", (Object)((BaseProperties)this.context.getBean(BaseProperties.class)).name);
    }

    @Test
    public void testArrayPropertiesBinding() {
        this.context.register(new Class[]{TestConfiguration.class});
        EnvironmentTestUtils.addEnvironment((ConfigurableApplicationContext)this.context, (String[])new String[]{"name:foo", "array:1,2,3"});
        this.context.refresh();
        Assert.assertEquals((long)1L, (long)this.context.getBeanNamesForType(TestProperties.class).length);
        Assert.assertEquals((long)3L, (long)((TestProperties)this.context.getBean(TestProperties.class)).getArray().length);
    }

    @Test
    public void testCollectionPropertiesBindingFromYamlArray() {
        this.context.register(new Class[]{TestConfiguration.class});
        EnvironmentTestUtils.addEnvironment((ConfigurableApplicationContext)this.context, (String[])new String[]{"name:foo", "list[0]:1", "list[1]:2"});
        this.context.refresh();
        Assert.assertEquals((long)2L, (long)((TestProperties)this.context.getBean(TestProperties.class)).getList().size());
    }

    @Test
    public void testPropertiesBindingWithoutAnnotation() {
        this.context.register(new Class[]{MoreConfiguration.class});
        EnvironmentTestUtils.addEnvironment((ConfigurableApplicationContext)this.context, (String[])new String[]{"name:foo"});
        this.context.refresh();
        Assert.assertEquals((long)1L, (long)this.context.getBeanNamesForType(MoreProperties.class).length);
        Assert.assertEquals((Object)"foo", (Object)((MoreProperties)this.context.getBean(MoreProperties.class)).name);
    }

    @Test
    public void testPropertiesBindingWithDefaultsInXml() {
        this.context.register(new Class[]{TestConfiguration.class, DefaultXmlConfiguration.class});
        this.context.refresh();
        String[] beanNames = this.context.getBeanNamesForType(TestProperties.class);
        Assert.assertEquals((String)("Wrong beans: " + Arrays.asList(beanNames)), (long)1L, (long)beanNames.length);
        Assert.assertEquals((Object)"bar", (Object)((TestProperties)this.context.getBean(TestProperties.class)).name);
    }

    @Test
    public void testPropertiesBindingWithDefaultsInBeanMethod() {
        this.context.register(new Class[]{DefaultConfiguration.class});
        this.context.refresh();
        String[] beanNames = this.context.getBeanNamesForType(TestProperties.class);
        Assert.assertEquals((String)("Wrong beans: " + Arrays.asList(beanNames)), (long)1L, (long)beanNames.length);
        Assert.assertEquals((Object)"bar", (Object)((TestProperties)this.context.getBean(TestProperties.class)).name);
    }

    @Test
    public void testBindingDirectlyToFile() {
        this.context.register(new Class[]{ResourceBindingProperties.class, TestConfiguration.class});
        this.context.refresh();
        Assert.assertEquals((long)1L, (long)this.context.getBeanNamesForType(ResourceBindingProperties.class).length);
        Assert.assertEquals((Object)"foo", (Object)((ResourceBindingProperties)this.context.getBean(ResourceBindingProperties.class)).name);
    }

    @Test
    public void testBindingDirectlyToFileResolvedFromEnvironment() {
        EnvironmentTestUtils.addEnvironment((ConfigurableApplicationContext)this.context, (String[])new String[]{"binding.location:classpath:other.yml"});
        this.context.register(new Class[]{ResourceBindingProperties.class, TestConfiguration.class});
        this.context.refresh();
        Assert.assertEquals((long)1L, (long)this.context.getBeanNamesForType(ResourceBindingProperties.class).length);
        Assert.assertEquals((Object)"other", (Object)((ResourceBindingProperties)this.context.getBean(ResourceBindingProperties.class)).name);
    }

    @Test
    public void testBindingDirectlyToFileWithDefaultsWhenProfileNotFound() {
        this.context.register(new Class[]{ResourceBindingProperties.class, TestConfiguration.class});
        this.context.getEnvironment().addActiveProfile("nonexistent");
        this.context.refresh();
        Assert.assertEquals((long)1L, (long)this.context.getBeanNamesForType(ResourceBindingProperties.class).length);
        Assert.assertEquals((Object)"foo", (Object)((ResourceBindingProperties)this.context.getBean(ResourceBindingProperties.class)).name);
    }

    @Test
    public void testBindingDirectlyToFileWithExplicitSpringProfile() {
        this.context.register(new Class[]{ResourceBindingProperties.class, TestConfiguration.class});
        this.context.getEnvironment().addActiveProfile("super");
        this.context.refresh();
        Assert.assertEquals((long)1L, (long)this.context.getBeanNamesForType(ResourceBindingProperties.class).length);
        Assert.assertEquals((Object)"bar", (Object)((ResourceBindingProperties)this.context.getBean(ResourceBindingProperties.class)).name);
    }

    @Test
    public void testBindingDirectlyToFileWithTwoExplicitSpringProfiles() {
        this.context.register(new Class[]{ResourceBindingProperties.class, TestConfiguration.class});
        this.context.getEnvironment().setActiveProfiles(new String[]{"super", "other"});
        this.context.refresh();
        Assert.assertEquals((long)1L, (long)this.context.getBeanNamesForType(ResourceBindingProperties.class).length);
        Assert.assertEquals((Object)"spam", (Object)((ResourceBindingProperties)this.context.getBean(ResourceBindingProperties.class)).name);
    }

    @Test
    public void testBindingWithTwoBeans() {
        this.context.register(new Class[]{MoreConfiguration.class, TestConfiguration.class});
        this.context.refresh();
        Assert.assertEquals((long)1L, (long)this.context.getBeanNamesForType(TestProperties.class).length);
        Assert.assertEquals((long)1L, (long)this.context.getBeanNamesForType(MoreProperties.class).length);
    }

    @Test
    public void testBindingWithParentContext() {
        AnnotationConfigApplicationContext parent = new AnnotationConfigApplicationContext();
        parent.register(new Class[]{TestConfiguration.class});
        parent.refresh();
        EnvironmentTestUtils.addEnvironment((ConfigurableApplicationContext)this.context, (String[])new String[]{"name:foo"});
        this.context.setParent((ApplicationContext)parent);
        this.context.register(new Class[]{TestConfiguration.class, TestConsumer.class});
        this.context.refresh();
        Assert.assertEquals((long)1L, (long)this.context.getBeanNamesForType(TestProperties.class).length);
        Assert.assertEquals((long)1L, (long)parent.getBeanNamesForType(TestProperties.class).length);
        Assert.assertEquals((Object)"foo", (Object)((TestConsumer)this.context.getBean(TestConsumer.class)).getName());
    }

    @Test
    public void testBindingOnlyParentContext() {
        AnnotationConfigApplicationContext parent = new AnnotationConfigApplicationContext();
        EnvironmentTestUtils.addEnvironment((ConfigurableApplicationContext)parent, (String[])new String[]{"name:foo"});
        parent.register(new Class[]{TestConfiguration.class});
        parent.refresh();
        this.context.setParent((ApplicationContext)parent);
        this.context.register(new Class[]{TestConsumer.class});
        this.context.refresh();
        Assert.assertEquals((long)0L, (long)this.context.getBeanNamesForType(TestProperties.class).length);
        Assert.assertEquals((long)1L, (long)parent.getBeanNamesForType(TestProperties.class).length);
        Assert.assertEquals((Object)"foo", (Object)((TestConsumer)this.context.getBean(TestConsumer.class)).getName());
    }

    @Test
    public void testUnderscoresInPrefix() throws Exception {
        EnvironmentTestUtils.addEnvironment((ConfigurableApplicationContext)this.context, (String[])new String[]{"spring_test_external_val:baz"});
        this.context.register(new Class[]{SystemExampleConfig.class});
        this.context.refresh();
        Assert.assertEquals((Object)"baz", (Object)((SystemEnvVar)this.context.getBean(SystemEnvVar.class)).getVal());
    }

    @Test
    public void testSimpleAutoConfig() throws Exception {
        EnvironmentTestUtils.addEnvironment((ConfigurableApplicationContext)this.context, (String[])new String[]{"external.name:foo"});
        this.context.register(new Class[]{ExampleConfig.class});
        this.context.refresh();
        Assert.assertEquals((Object)"foo", (Object)((External)this.context.getBean(External.class)).getName());
    }

    @Test
    public void testExplicitType() throws Exception {
        EnvironmentTestUtils.addEnvironment((ConfigurableApplicationContext)this.context, (String[])new String[]{"external.name:foo"});
        this.context.register(new Class[]{AnotherExampleConfig.class});
        this.context.refresh();
        Assert.assertEquals((Object)"foo", (Object)((External)this.context.getBean(External.class)).getName());
    }

    @Test
    public void testMultipleExplicitTypes() throws Exception {
        EnvironmentTestUtils.addEnvironment((ConfigurableApplicationContext)this.context, (String[])new String[]{"external.name:foo", "another.name:bar"});
        this.context.register(new Class[]{FurtherExampleConfig.class});
        this.context.refresh();
        Assert.assertEquals((Object)"foo", (Object)((External)this.context.getBean(External.class)).getName());
        Assert.assertEquals((Object)"bar", (Object)((Another)this.context.getBean(Another.class)).getName());
    }

    @Test
    public void testBindingWithMapKeyWithPeriod() {
        this.context.register(new Class[]{ResourceBindingPropertiesWithMap.class});
        this.context.refresh();
        ResourceBindingPropertiesWithMap bean = (ResourceBindingPropertiesWithMap)this.context.getBean(ResourceBindingPropertiesWithMap.class);
        Assert.assertEquals((Object)"value3", bean.mymap.get("key3"));
        Assert.assertEquals((Object)"value12", bean.mymap.get("key1.key2"));
    }

    private void removeSystemProperties() {
        MutablePropertySources sources = this.context.getEnvironment().getPropertySources();
        sources.remove("systemProperties");
        sources.remove("systemEnvironment");
    }

    @EnableConfigurationProperties
    @ConfigurationProperties(locations={"${binding.location:classpath:map.yml}"})
    protected static class ResourceBindingPropertiesWithMap {
        private Map<String, String> mymap;

        protected ResourceBindingPropertiesWithMap() {
        }

        public void setMymap(Map<String, String> mymap) {
            this.mymap = mymap;
        }

        public Map<String, String> getMymap() {
            return this.mymap;
        }
    }

    @ConfigurationProperties(locations={"${binding.location:classpath:name.yml}"})
    protected static class ResourceBindingProperties {
        private String name;

        protected ResourceBindingProperties() {
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    protected static class MoreProperties {
        private String name;

        protected MoreProperties() {
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    @ConfigurationProperties(exceptionIfInvalid=false)
    protected static class NoExceptionIfInvalidTestProperties
    extends TestProperties {
        @NotNull
        private String description;

        protected NoExceptionIfInvalidTestProperties() {
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }
    }

    @ConfigurationProperties
    protected static class ExceptionIfInvalidTestProperties
    extends TestProperties {
        @NotNull
        private String description;

        protected ExceptionIfInvalidTestProperties() {
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }
    }

    @ConfigurationProperties(ignoreUnknownFields=false, ignoreNestedProperties=true)
    protected static class IgnoreNestedTestProperties
    extends TestProperties {
        protected IgnoreNestedTestProperties() {
        }
    }

    @ConfigurationProperties(prefix="spring.foo")
    protected static class EmbeddedTestProperties
    extends TestProperties {
        protected EmbeddedTestProperties() {
        }
    }

    @ConfigurationProperties(ignoreUnknownFields=false)
    protected static class StrictTestProperties
    extends TestProperties {
        protected StrictTestProperties() {
        }
    }

    @ConfigurationProperties
    protected static class TestProperties {
        private String name;
        private int[] array;
        private final List<Integer> list = new ArrayList<Integer>();

        protected TestProperties() {
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setArray(int ... values) {
            this.array = values;
        }

        public int[] getArray() {
            return this.array;
        }

        public List<Integer> getList() {
            return this.list;
        }
    }

    protected static class DerivedProperties
    extends BaseProperties {
        protected DerivedProperties() {
        }
    }

    @ConfigurationProperties
    protected static class BaseProperties {
        private String name;

        protected BaseProperties() {
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    @ConfigurationProperties
    protected static class NestedProperties {
        private String name;
        private final Nested nested = new Nested();

        protected NestedProperties() {
        }

        public void setName(String name) {
            this.name = name;
        }

        public Nested getNested() {
            return this.nested;
        }

        protected static class Nested {
            private String name;

            protected Nested() {
            }

            public void setName(String name) {
                this.name = name;
            }
        }
    }

    @Configuration
    @EnableConfigurationProperties(value={MoreProperties.class})
    protected static class MoreConfiguration {
        protected MoreConfiguration() {
        }
    }

    @Component
    protected static class TestConsumer {
        @Autowired
        private TestProperties properties;

        protected TestConsumer() {
        }

        @PostConstruct
        public void init() {
            Assert.assertNotNull((Object)this.properties);
        }

        public String getName() {
            return this.properties.name;
        }
    }

    @ConfigurationProperties(prefix="spring_test_external")
    public static class SystemEnvVar {
        private String val;

        public String getVal() {
            return this.val;
        }

        public void setVal(String val) {
            this.val = val;
        }
    }

    @ConfigurationProperties(prefix="another")
    public static class Another {
        private String name;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    @ConfigurationProperties(prefix="external")
    public static class External {
        private String name;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    @EnableConfigurationProperties(value={SystemEnvVar.class})
    @Configuration
    public static class SystemExampleConfig {
    }

    @EnableConfigurationProperties(value={External.class, Another.class})
    @Configuration
    public static class FurtherExampleConfig {
    }

    @EnableConfigurationProperties(value={External.class})
    @Configuration
    public static class AnotherExampleConfig {
    }

    @EnableConfigurationProperties
    @Configuration
    public static class ExampleConfig {
        @Bean
        public External external() {
            return new External();
        }
    }

    @Configuration
    @ImportResource(value={"org/springframework/boot/context/properties/testProperties.xml"})
    protected static class DefaultXmlConfiguration {
        protected DefaultXmlConfiguration() {
        }
    }

    @Configuration
    protected static class DefaultConfiguration {
        protected DefaultConfiguration() {
        }

        @Bean
        public TestProperties testProperties() {
            TestProperties test = new TestProperties();
            test.setName("bar");
            return test;
        }
    }

    @Configuration
    @EnableConfigurationProperties(value={NestedProperties.class})
    protected static class NestedConfiguration {
        protected NestedConfiguration() {
        }
    }

    @Configuration
    @EnableConfigurationProperties(value={DerivedProperties.class})
    protected static class DerivedConfiguration {
        protected DerivedConfiguration() {
        }
    }

    @Configuration
    @EnableConfigurationProperties(value={NoExceptionIfInvalidTestProperties.class})
    protected static class NoExceptionIfInvalidTestConfiguration {
        protected NoExceptionIfInvalidTestConfiguration() {
        }
    }

    @Configuration
    @EnableConfigurationProperties(value={ExceptionIfInvalidTestProperties.class})
    protected static class ExceptionIfInvalidTestConfiguration {
        protected ExceptionIfInvalidTestConfiguration() {
        }
    }

    @Configuration
    @EnableConfigurationProperties(value={IgnoreNestedTestProperties.class})
    protected static class IgnoreNestedTestConfiguration {
        protected IgnoreNestedTestConfiguration() {
        }
    }

    @Configuration
    @EnableConfigurationProperties(value={EmbeddedTestProperties.class})
    protected static class EmbeddedTestConfiguration {
        protected EmbeddedTestConfiguration() {
        }
    }

    @Configuration
    @EnableConfigurationProperties(value={StrictTestProperties.class})
    protected static class StrictTestConfiguration {
        protected StrictTestConfiguration() {
        }
    }

    @Configuration
    @EnableConfigurationProperties(value={TestProperties.class})
    protected static class TestConfiguration {
        protected TestConfiguration() {
        }
    }
}

