/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.context.embedded.EmbeddedServletContainerFactory;
import org.springframework.boot.context.embedded.tomcat.TomcatEmbeddedServletContainerFactory;
import org.springframework.boot.test.IntegrationTest;
import org.springframework.boot.test.SpringApplicationConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;

@RunWith(value=SpringJUnit4ClassRunner.class)
@SpringApplicationConfiguration(classes={Config.class})
@WebAppConfiguration
@IntegrationTest
public class SpringApplicationIntegrationTestTests {
    @Test
    public void runAndTestHttpEndpoint() {
        String body = (String)new RestTemplate().getForObject("http://localhost:8080/", String.class, new Object[0]);
        Assert.assertEquals((Object)"Hello World", (Object)body);
    }

    @Configuration
    @EnableWebMvc
    @RestController
    protected static class Config {
        protected Config() {
        }

        @Bean
        public DispatcherServlet dispatcherServlet() {
            return new DispatcherServlet();
        }

        @Bean
        public EmbeddedServletContainerFactory embeddedServletContainer() {
            return new TomcatEmbeddedServletContainerFactory();
        }

        @RequestMapping(value={"/"})
        public String home() {
            return "Hello World";
        }
    }
}

