/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.springframework.boot.ApplicationPid;
import org.springframework.util.FileCopyUtils;

public class ApplicationPidTests {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void toStringWithPid() throws Exception {
        Assert.assertThat((Object)new ApplicationPid("123").toString(), (Matcher)Matchers.equalTo((Object)"123"));
    }

    @Test
    public void toStringWithoutPid() throws Exception {
        Assert.assertThat((Object)new ApplicationPid(null).toString(), (Matcher)Matchers.equalTo((Object)"???"));
    }

    @Test
    public void throwIllegalStateWritingMissingPid() throws Exception {
        ApplicationPid pid = new ApplicationPid(null);
        this.thrown.expect(IllegalStateException.class);
        this.thrown.expectMessage("No PID available");
        pid.write(this.temporaryFolder.newFile());
    }

    @Test
    public void writePid() throws Exception {
        ApplicationPid pid = new ApplicationPid("123");
        File file = this.temporaryFolder.newFile();
        pid.write(file);
        String actual = FileCopyUtils.copyToString((Reader)new FileReader(file));
        Assert.assertThat((Object)actual, (Matcher)Matchers.equalTo((Object)"123"));
    }

    @Test
    public void getPidFromJvm() throws Exception {
        Assert.assertThat((Object)new ApplicationPid().toString(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyOrNullString()));
    }
}

