/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.bind;

import java.io.IOException;
import javax.validation.Validation;
import javax.validation.constraints.NotNull;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.NotWritablePropertyException;
import org.springframework.boot.bind.PropertiesConfigurationFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.support.StaticMessageSource;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.validation.BindException;
import org.springframework.validation.Validator;
import org.springframework.validation.beanvalidation.SpringValidatorAdapter;

public class PropertiesConfigurationFactoryTests {
    private PropertiesConfigurationFactory<Foo> factory;
    private Validator validator;
    private boolean ignoreUnknownFields = true;
    private String targetName = null;

    @Test
    public void testValidPropertiesLoadsWithNoErrors() throws Exception {
        Foo foo = this.createFoo("name: blah\nbar: blah");
        Assert.assertEquals((Object)"blah", (Object)foo.bar);
        Assert.assertEquals((Object)"blah", (Object)foo.name);
    }

    @Test
    public void testValidPropertiesLoadsWithUpperCase() throws Exception {
        Foo foo = this.createFoo("NAME: blah\nbar: blah");
        Assert.assertEquals((Object)"blah", (Object)foo.bar);
        Assert.assertEquals((Object)"blah", (Object)foo.name);
    }

    @Test
    public void testValidPropertiesLoadsWithDash() throws Exception {
        Foo foo = this.createFoo("na-me: blah\nbar: blah");
        Assert.assertEquals((Object)"blah", (Object)foo.bar);
        Assert.assertEquals((Object)"blah", (Object)foo.name);
    }

    @Test
    public void testUnderscore() throws Exception {
        Foo foo = this.createFoo("spring_foo_baz: blah\nname: blah");
        Assert.assertEquals((Object)"blah", (Object)foo.spring_foo_baz);
        Assert.assertEquals((Object)"blah", (Object)foo.name);
    }

    @Test
    public void testUnknownPropertyOkByDefault() throws Exception {
        Foo foo = this.createFoo("hi: hello\nname: foo\nbar: blah");
        Assert.assertEquals((Object)"blah", (Object)foo.bar);
    }

    @Test(expected=NotWritablePropertyException.class)
    public void testUnknownPropertyCausesLoadFailure() throws Exception {
        this.ignoreUnknownFields = false;
        this.createFoo("hi: hello\nname: foo\nbar: blah");
    }

    @Test(expected=BindException.class)
    public void testMissingPropertyCausesValidationError() throws Exception {
        this.validator = new SpringValidatorAdapter(Validation.buildDefaultValidatorFactory().getValidator());
        this.createFoo("bar: blah");
    }

    @Test
    public void testValidationErrorCanBeSuppressed() throws Exception {
        this.validator = new SpringValidatorAdapter(Validation.buildDefaultValidatorFactory().getValidator());
        this.setupFactory();
        this.factory.setExceptionIfInvalid(false);
        this.bindFoo("bar: blah");
    }

    @Test
    public void testBindToNamedTarget() throws Exception {
        this.targetName = "foo";
        Foo foo = this.createFoo("hi: hello\nfoo.name: foo\nfoo.bar: blah");
        Assert.assertEquals((Object)"blah", (Object)foo.bar);
    }

    private Foo createFoo(String values) throws Exception {
        this.setupFactory();
        return this.bindFoo(values);
    }

    private Foo bindFoo(String values) throws Exception {
        this.factory.setProperties(PropertiesLoaderUtils.loadProperties((Resource)new ByteArrayResource(values.getBytes())));
        this.factory.afterPropertiesSet();
        return (Foo)this.factory.getObject();
    }

    private void setupFactory() throws IOException {
        this.factory = new PropertiesConfigurationFactory(Foo.class);
        this.factory.setValidator(this.validator);
        this.factory.setTargetName(this.targetName);
        this.factory.setIgnoreUnknownFields(this.ignoreUnknownFields);
        this.factory.setMessageSource((MessageSource)new StaticMessageSource());
    }

    public static class Foo {
        @NotNull
        private String name;
        private String bar;
        private String spring_foo_baz;

        public String getSpringFooBaz() {
            return this.spring_foo_baz;
        }

        public void setSpringFooBaz(String spring_foo_baz) {
            this.spring_foo_baz = spring_foo_baz;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getBar() {
            return this.bar;
        }

        public void setBar(String bar) {
            this.bar = bar;
        }
    }
}

