/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.config;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.config.ConfigFileApplicationListener;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.boot.env.EnumerableCompositePropertySource;
import org.springframework.boot.test.EnvironmentTestUtils;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySources;
import org.springframework.core.env.SimpleCommandLinePropertySource;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class ConfigFileApplicationListenerTests {
    private final StandardEnvironment environment = new StandardEnvironment();
    private final ApplicationEnvironmentPreparedEvent event = new ApplicationEnvironmentPreparedEvent(new SpringApplication(new Object[0]), new String[0], (ConfigurableEnvironment)this.environment);
    private final ConfigFileApplicationListener initializer = new ConfigFileApplicationListener();
    @Rule
    public ExpectedException expected = ExpectedException.none();

    @After
    public void cleanup() {
        System.clearProperty("my.property");
        System.clearProperty("spring.config.location");
    }

    @Test
    public void loadCustomResource() throws Exception {
        this.event.getSpringApplication().setResourceLoader(new ResourceLoader(){

            public Resource getResource(final String location) {
                if (location.equals("classpath:/custom.properties")) {
                    return new ByteArrayResource("my.property: fromcustom".getBytes(), location){

                        public String getFilename() {
                            return location;
                        }
                    };
                }
                return null;
            }

            public ClassLoader getClassLoader() {
                return this.getClass().getClassLoader();
            }
        });
        this.initializer.setSearchNames("custom");
        this.initializer.onApplicationEvent((ApplicationEvent)this.event);
        String property = this.environment.getProperty("my.property");
        Assert.assertThat((Object)property, (Matcher)Matchers.equalTo((Object)"fromcustom"));
    }

    @Test
    public void loadPropertiesFile() throws Exception {
        this.initializer.setSearchNames("testproperties");
        this.initializer.onApplicationEvent((ApplicationEvent)this.event);
        String property = this.environment.getProperty("my.property");
        Assert.assertThat((Object)property, (Matcher)Matchers.equalTo((Object)"frompropertiesfile"));
    }

    @Test
    public void loadTwoPropertiesFile() throws Exception {
        EnvironmentTestUtils.addEnvironment((ConfigurableEnvironment)this.environment, (String[])new String[]{"spring.config.location:classpath:application.properties,classpath:testproperties.properties"});
        this.initializer.onApplicationEvent((ApplicationEvent)this.event);
        String property = this.environment.getProperty("my.property");
        Assert.assertThat((Object)property, (Matcher)Matchers.equalTo((Object)"frompropertiesfile"));
    }

    @Test
    public void loadTwoPropertiesFilesWithProfiles() throws Exception {
        EnvironmentTestUtils.addEnvironment((ConfigurableEnvironment)this.environment, (String[])new String[]{"spring.config.location:classpath:enableprofile.properties,classpath:enableother.properties"});
        this.initializer.onApplicationEvent((ApplicationEvent)this.event);
        Assert.assertEquals((Object)"other", (Object)StringUtils.arrayToCommaDelimitedString((Object[])this.environment.getActiveProfiles()));
        String property = this.environment.getProperty("my.property");
        Assert.assertThat((Object)property, (Matcher)Matchers.equalTo((Object)"fromotherpropertiesfile"));
    }

    @Test
    public void loadTwoPropertiesFilesWithProfilesAndSwitchOneOff() throws Exception {
        EnvironmentTestUtils.addEnvironment((ConfigurableEnvironment)this.environment, (String[])new String[]{"spring.config.location:classpath:enabletwoprofiles.properties,classpath:enableprofile.properties"});
        this.initializer.onApplicationEvent((ApplicationEvent)this.event);
        Assert.assertEquals((Object)"myprofile", (Object)StringUtils.arrayToCommaDelimitedString((Object[])this.environment.getActiveProfiles()));
        String property = this.environment.getProperty("my.property");
        Assert.assertThat((Object)property, (Matcher)Matchers.equalTo((Object)"frompropertiesfile"));
    }

    @Test
    public void loadTwoPropertiesFilesWithProfilesAndSwitchOneOffFromSpecificLocation() throws Exception {
        EnvironmentTestUtils.addEnvironment((ConfigurableEnvironment)this.environment, (String[])new String[]{"spring.config.name:enabletwoprofiles", "spring.config.location:classpath:enableprofile.properties"});
        this.initializer.onApplicationEvent((ApplicationEvent)this.event);
        Assert.assertEquals((Object)"myprofile", (Object)StringUtils.arrayToCommaDelimitedString((Object[])this.environment.getActiveProfiles()));
        String property = this.environment.getProperty("my.property");
        Assert.assertThat((Object)property, (Matcher)Matchers.equalTo((Object)"frompropertiesfile"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void localFileTakesPrecedenceOverClasspath() throws Exception {
        File localFile = new File(new File("."), "application.properties");
        Assert.assertThat((Object)localFile.exists(), (Matcher)Matchers.equalTo((Object)false));
        try {
            Properties properties = new Properties();
            properties.put("my.property", "fromlocalfile");
            FileOutputStream out = new FileOutputStream(localFile);
            try {
                properties.store(out, "");
            }
            finally {
                ((OutputStream)out).close();
            }
            this.initializer.onApplicationEvent((ApplicationEvent)this.event);
            String property = this.environment.getProperty("my.property");
            Assert.assertThat((Object)property, (Matcher)Matchers.equalTo((Object)"fromlocalfile"));
        }
        finally {
            localFile.delete();
        }
    }

    @Test
    public void moreSpecificLocationTakesPrecedenceOverRoot() throws Exception {
        EnvironmentTestUtils.addEnvironment((ConfigurableEnvironment)this.environment, (String[])new String[]{"spring.config.name:specific"});
        this.initializer.onApplicationEvent((ApplicationEvent)this.event);
        String property = this.environment.getProperty("my.property");
        Assert.assertThat((Object)property, (Matcher)Matchers.equalTo((Object)"specific"));
    }

    @Test
    public void loadTwoOfThreePropertiesFile() throws Exception {
        EnvironmentTestUtils.addEnvironment((ConfigurableEnvironment)this.environment, (String[])new String[]{"spring.config.location:classpath:application.properties,classpath:testproperties.properties,classpath:nonexistent.properties"});
        this.initializer.onApplicationEvent((ApplicationEvent)this.event);
        String property = this.environment.getProperty("my.property");
        Assert.assertThat((Object)property, (Matcher)Matchers.equalTo((Object)"frompropertiesfile"));
    }

    @Test
    public void randomValue() throws Exception {
        this.initializer.onApplicationEvent((ApplicationEvent)this.event);
        String property = this.environment.getProperty("random.value");
        Assert.assertThat((Object)property, (Matcher)Matchers.notNullValue());
    }

    @Test
    public void loadTwoPropertiesFiles() throws Exception {
        this.initializer.setSearchNames("moreproperties,testproperties");
        this.initializer.onApplicationEvent((ApplicationEvent)this.event);
        String property = this.environment.getProperty("my.property");
        Assert.assertThat((Object)property, (Matcher)Matchers.equalTo((Object)"frompropertiesfile"));
    }

    @Test
    public void loadYamlFile() throws Exception {
        this.initializer.setSearchNames("testyaml");
        this.initializer.onApplicationEvent((ApplicationEvent)this.event);
        String property = this.environment.getProperty("my.property");
        Assert.assertThat((Object)property, (Matcher)Matchers.equalTo((Object)"fromyamlfile"));
        Assert.assertThat((Object)this.environment.getProperty("my.array[0]"), (Matcher)Matchers.equalTo((Object)"1"));
        Assert.assertThat((Object)this.environment.getProperty("my.array"), (Matcher)Matchers.nullValue(String.class));
    }

    @Test
    public void commandLineWins() throws Exception {
        this.environment.getPropertySources().addFirst((org.springframework.core.env.PropertySource)new SimpleCommandLinePropertySource(new String[]{"--my.property=fromcommandline"}));
        this.initializer.setSearchNames("testproperties");
        this.initializer.onApplicationEvent((ApplicationEvent)this.event);
        String property = this.environment.getProperty("my.property");
        Assert.assertThat((Object)property, (Matcher)Matchers.equalTo((Object)"fromcommandline"));
    }

    @Test
    public void systemPropertyWins() throws Exception {
        System.setProperty("my.property", "fromsystem");
        this.initializer.setSearchNames("testproperties");
        this.initializer.onApplicationEvent((ApplicationEvent)this.event);
        String property = this.environment.getProperty("my.property");
        Assert.assertThat((Object)property, (Matcher)Matchers.equalTo((Object)"fromsystem"));
    }

    @Test
    public void loadPropertiesThenProfilePropertiesActivatedInSpringApplication() throws Exception {
        this.environment.setActiveProfiles(new String[]{"other"});
        this.initializer.onApplicationEvent((ApplicationEvent)this.event);
        String property = this.environment.getProperty("my.property");
        Assert.assertThat((Object)property, (Matcher)Matchers.equalTo((Object)"fromotherpropertiesfile"));
    }

    @Test
    public void loadPropertiesThenProfilePropertiesActivatedInFirst() throws Exception {
        this.initializer.setSearchNames("enableprofile");
        this.initializer.onApplicationEvent((ApplicationEvent)this.event);
        String property = this.environment.getProperty("my.property");
        Assert.assertThat((Object)property, (Matcher)Matchers.equalTo((Object)"fromprofilepropertiesfile"));
    }

    @Test
    public void loadPropertiesThenProfilePropertiesWithOverride() throws Exception {
        this.environment.setActiveProfiles(new String[]{"other"});
        this.initializer.setSearchNames("enableprofile");
        this.initializer.onApplicationEvent((ApplicationEvent)this.event);
        String property = this.environment.getProperty("other.property");
        Assert.assertThat((Object)property, (Matcher)Matchers.equalTo((Object)"fromotherpropertiesfile"));
        property = this.environment.getProperty("my.property");
        Assert.assertThat((Object)property, (Matcher)Matchers.equalTo((Object)"fromprofilepropertiesfile"));
    }

    @Test
    public void profilePropertiesUsedInPlaceholders() throws Exception {
        this.initializer.setSearchNames("enableprofile");
        this.initializer.onApplicationEvent((ApplicationEvent)this.event);
        String property = this.environment.getProperty("one.more");
        Assert.assertThat((Object)property, (Matcher)Matchers.equalTo((Object)"fromprofilepropertiesfile"));
    }

    @Test
    public void yamlProfiles() throws Exception {
        this.initializer.setSearchNames("testprofiles");
        this.environment.setActiveProfiles(new String[]{"dev"});
        this.initializer.onApplicationEvent((ApplicationEvent)this.event);
        String property = this.environment.getProperty("my.property");
        Assert.assertThat((Object)property, (Matcher)Matchers.equalTo((Object)"fromdevprofile"));
        property = this.environment.getProperty("my.other");
        Assert.assertThat((Object)property, (Matcher)Matchers.equalTo((Object)"notempty"));
    }

    @Test
    public void yamlTwoProfiles() throws Exception {
        this.initializer.setSearchNames("testprofiles");
        this.environment.setActiveProfiles(new String[]{"other", "dev"});
        this.initializer.onApplicationEvent((ApplicationEvent)this.event);
        String property = this.environment.getProperty("my.property");
        Assert.assertThat((Object)property, (Matcher)Matchers.equalTo((Object)"fromotherprofile"));
        property = this.environment.getProperty("my.other");
        Assert.assertThat((Object)property, (Matcher)Matchers.equalTo((Object)"notempty"));
    }

    @Test
    public void yamlSetsProfiles() throws Exception {
        this.initializer.setSearchNames("testsetprofiles");
        this.initializer.onApplicationEvent((ApplicationEvent)this.event);
        Assert.assertEquals((Object)"dev", (Object)StringUtils.arrayToCommaDelimitedString((Object[])this.environment.getActiveProfiles()));
        String property = this.environment.getProperty("my.property");
        Assert.assertThat(Arrays.asList(this.environment.getActiveProfiles()), (Matcher)Matchers.contains((Object[])new String[]{"dev"}));
        Assert.assertThat((Object)property, (Matcher)Matchers.equalTo((Object)"fromdevprofile"));
        ConfigFileApplicationListener.ConfigurationPropertySources propertySource = (ConfigFileApplicationListener.ConfigurationPropertySources)this.environment.getPropertySources().get("applicationConfigurationProperties");
        Collection sources = (Collection)propertySource.getSource();
        Assert.assertEquals((long)2L, (long)sources.size());
        ArrayList<String> names = new ArrayList<String>();
        for (org.springframework.core.env.PropertySource source : sources) {
            if (source instanceof EnumerableCompositePropertySource) {
                for (org.springframework.core.env.PropertySource nested : (Collection)((EnumerableCompositePropertySource)source).getSource()) {
                    names.add(nested.getName());
                }
                continue;
            }
            names.add(source.getName());
        }
        Assert.assertThat(names, (Matcher)Matchers.contains((Object[])new String[]{"applicationConfig: [classpath:/testsetprofiles.yml]#dev", "applicationConfig: [classpath:/testsetprofiles.yml]"}));
    }

    @Test
    public void yamlProfileCanBeChanged() throws Exception {
        EnvironmentTestUtils.addEnvironment((ConfigurableEnvironment)this.environment, (String[])new String[]{"spring.profiles.active:prod"});
        this.initializer.setSearchNames("testsetprofiles");
        this.initializer.onApplicationEvent((ApplicationEvent)this.event);
        Assert.assertThat((Object)this.environment.getActiveProfiles(), (Matcher)Matchers.equalTo((Object)new String[]{"prod"}));
    }

    @Test
    public void specificNameAndProfileFromExistingSource() throws Exception {
        EnvironmentTestUtils.addEnvironment((ConfigurableEnvironment)this.environment, (String[])new String[]{"spring.profiles.active=specificprofile", "spring.config.name=specificfile"});
        this.initializer.onApplicationEvent((ApplicationEvent)this.event);
        String property = this.environment.getProperty("my.property");
        Assert.assertThat((Object)property, (Matcher)Matchers.equalTo((Object)"fromspecificpropertiesfile"));
    }

    @Test
    public void specificResource() throws Exception {
        String location = "classpath:specificlocation.properties";
        EnvironmentTestUtils.addEnvironment((ConfigurableEnvironment)this.environment, (String[])new String[]{"spring.config.location:" + location});
        this.initializer.onApplicationEvent((ApplicationEvent)this.event);
        String property = this.environment.getProperty("my.property");
        Assert.assertThat((Object)property, (Matcher)Matchers.equalTo((Object)"fromspecificlocation"));
        Assert.assertThat((Object)this.environment, ConfigFileApplicationListenerTests.containsPropertySource("applicationConfig: [classpath:specificlocation.properties]"));
        Assert.assertThat((Object)this.environment, ConfigFileApplicationListenerTests.containsPropertySource("applicationConfig: [classpath:/application.properties]"));
        Assert.assertThat((Object)this.environment.getProperty("foo"), (Matcher)Matchers.equalTo((Object)"bucket"));
    }

    @Test
    public void specificResourceAsFile() throws Exception {
        String location = "file:src/test/resources/specificlocation.properties";
        EnvironmentTestUtils.addEnvironment((ConfigurableEnvironment)this.environment, (String[])new String[]{"spring.config.location:" + location});
        this.initializer.onApplicationEvent((ApplicationEvent)this.event);
        Assert.assertThat((Object)this.environment, ConfigFileApplicationListenerTests.containsPropertySource("applicationConfig: [" + location + "]"));
    }

    @Test
    public void specificResourceDefaultsToFile() throws Exception {
        String location = "src/test/resources/specificlocation.properties";
        EnvironmentTestUtils.addEnvironment((ConfigurableEnvironment)this.environment, (String[])new String[]{"spring.config.location:" + location});
        this.initializer.onApplicationEvent((ApplicationEvent)this.event);
        Assert.assertThat((Object)this.environment, ConfigFileApplicationListenerTests.containsPropertySource("applicationConfig: [file:" + location + "]"));
    }

    @Test
    public void propertySourceAnnotation() throws Exception {
        SpringApplication application = new SpringApplication(new Object[]{WithPropertySource.class});
        application.setWebEnvironment(false);
        ConfigurableApplicationContext context = application.run(new String[0]);
        String property = context.getEnvironment().getProperty("my.property");
        Assert.assertThat((Object)property, (Matcher)Matchers.equalTo((Object)"fromspecificlocation"));
        Assert.assertThat((Object)context.getEnvironment(), ConfigFileApplicationListenerTests.containsPropertySource("class path resource [specificlocation.properties]"));
        context.close();
    }

    @Test
    public void propertySourceAnnotationWithPlaceholder() throws Exception {
        EnvironmentTestUtils.addEnvironment((ConfigurableEnvironment)this.environment, (String[])new String[]{"source.location:specificlocation"});
        SpringApplication application = new SpringApplication(new Object[]{WithPropertySourcePlaceholders.class});
        application.setEnvironment((ConfigurableEnvironment)this.environment);
        application.setWebEnvironment(false);
        ConfigurableApplicationContext context = application.run(new String[0]);
        String property = context.getEnvironment().getProperty("my.property");
        Assert.assertThat((Object)property, (Matcher)Matchers.equalTo((Object)"fromspecificlocation"));
        Assert.assertThat((Object)context.getEnvironment(), ConfigFileApplicationListenerTests.containsPropertySource("class path resource [specificlocation.properties]"));
        context.close();
    }

    @Test
    public void propertySourceAnnotationWithName() throws Exception {
        SpringApplication application = new SpringApplication(new Object[]{WithPropertySourceAndName.class});
        application.setWebEnvironment(false);
        ConfigurableApplicationContext context = application.run(new String[0]);
        String property = context.getEnvironment().getProperty("my.property");
        Assert.assertThat((Object)property, (Matcher)Matchers.equalTo((Object)"fromspecificlocation"));
        Assert.assertThat((Object)context.getEnvironment(), ConfigFileApplicationListenerTests.containsPropertySource("foo"));
        context.close();
    }

    @Test
    public void propertySourceAnnotationInProfile() throws Exception {
        SpringApplication application = new SpringApplication(new Object[]{WithPropertySourceInProfile.class});
        application.setWebEnvironment(false);
        ConfigurableApplicationContext context = application.run(new String[]{"--spring.profiles.active=myprofile"});
        String property = context.getEnvironment().getProperty("my.property");
        Assert.assertThat((Object)property, (Matcher)Matchers.equalTo((Object)"frompropertiesfile"));
        Assert.assertThat((Object)context.getEnvironment(), ConfigFileApplicationListenerTests.containsPropertySource("class path resource [enableprofile.properties]"));
        Assert.assertThat((Object)context.getEnvironment(), (Matcher)Matchers.not(ConfigFileApplicationListenerTests.containsPropertySource("classpath:/enableprofile-myprofile.properties")));
        context.close();
    }

    @Test
    public void propertySourceAnnotationAndNonActiveProfile() throws Exception {
        SpringApplication application = new SpringApplication(new Object[]{WithPropertySourceAndProfile.class});
        application.setWebEnvironment(false);
        ConfigurableApplicationContext context = application.run(new String[0]);
        String property = context.getEnvironment().getProperty("my.property");
        Assert.assertThat((Object)property, (Matcher)Matchers.equalTo((Object)"fromapplicationproperties"));
        Assert.assertThat((Object)context.getEnvironment(), (Matcher)Matchers.not(ConfigFileApplicationListenerTests.containsPropertySource("classpath:/enableprofile-myprofile.properties")));
        context.close();
    }

    @Test
    public void propertySourceAnnotationMultipleLocations() throws Exception {
        SpringApplication application = new SpringApplication(new Object[]{WithPropertySourceMultipleLocations.class});
        application.setWebEnvironment(false);
        ConfigurableApplicationContext context = application.run(new String[0]);
        String property = context.getEnvironment().getProperty("my.property");
        Assert.assertThat((Object)property, (Matcher)Matchers.equalTo((Object)"frommorepropertiesfile"));
        Assert.assertThat((Object)context.getEnvironment(), ConfigFileApplicationListenerTests.containsPropertySource("class path resource [specificlocation.properties]"));
        context.close();
    }

    @Test
    public void propertySourceAnnotationMultipleLocationsAndName() throws Exception {
        SpringApplication application = new SpringApplication(new Object[]{WithPropertySourceMultipleLocationsAndName.class});
        application.setWebEnvironment(false);
        ConfigurableApplicationContext context = application.run(new String[0]);
        String property = context.getEnvironment().getProperty("my.property");
        Assert.assertThat((Object)property, (Matcher)Matchers.equalTo((Object)"frommorepropertiesfile"));
        Assert.assertThat((Object)context.getEnvironment(), ConfigFileApplicationListenerTests.containsPropertySource("foo"));
        context.close();
    }

    @Test
    public void activateProfileFromProfileSpecificProperties() throws Exception {
        SpringApplication application = new SpringApplication(new Object[]{Config.class});
        application.setWebEnvironment(false);
        ConfigurableApplicationContext context = application.run(new String[]{"--spring.profiles.active=includeprofile"});
        Assert.assertThat((Object)context.getEnvironment(), ConfigFileApplicationListenerTests.acceptsProfiles("includeprofile"));
        Assert.assertThat((Object)context.getEnvironment(), ConfigFileApplicationListenerTests.acceptsProfiles("specific"));
        Assert.assertThat((Object)context.getEnvironment(), ConfigFileApplicationListenerTests.acceptsProfiles("morespecific"));
        Assert.assertThat((Object)context.getEnvironment(), ConfigFileApplicationListenerTests.acceptsProfiles("yetmorespecific"));
        Assert.assertThat((Object)context.getEnvironment(), (Matcher)Matchers.not(ConfigFileApplicationListenerTests.acceptsProfiles("missing")));
    }

    @Test
    public void profileSubDocumentInProfileSpecificFile() throws Exception {
        SpringApplication application = new SpringApplication(new Object[]{Config.class});
        application.setWebEnvironment(false);
        ConfigurableApplicationContext context = application.run(new String[]{"--spring.profiles.active=activeprofilewithsubdoc"});
        String property = context.getEnvironment().getProperty("foobar");
        Assert.assertThat((Object)property, (Matcher)Matchers.equalTo((Object)"baz"));
    }

    @Test
    public void bindsToSpringApplication() throws Exception {
        this.initializer.setSearchNames("bindtoapplication");
        this.initializer.onApplicationEvent((ApplicationEvent)this.event);
        SpringApplication application = this.event.getSpringApplication();
        Field field = ReflectionUtils.findField(SpringApplication.class, (String)"showBanner");
        field.setAccessible(true);
        Assert.assertThat((Object)((Boolean)field.get(application)), (Matcher)Matchers.equalTo((Object)false));
    }

    private static Matcher<? super ConfigurableEnvironment> containsPropertySource(final String sourceName) {
        return new TypeSafeDiagnosingMatcher<ConfigurableEnvironment>(){

            public void describeTo(Description description) {
                description.appendText("environment containing property source ").appendValue((Object)sourceName);
            }

            protected boolean matchesSafely(ConfigurableEnvironment item, Description mismatchDescription) {
                MutablePropertySources sources = new MutablePropertySources((PropertySources)item.getPropertySources());
                ConfigFileApplicationListener.ConfigurationPropertySources.finishAndRelocate((MutablePropertySources)sources);
                mismatchDescription.appendText("Not matched against: ").appendValue((Object)sources);
                return sources.contains(sourceName);
            }
        };
    }

    private static Matcher<? super ConfigurableEnvironment> acceptsProfiles(final String ... profiles) {
        return new TypeSafeDiagnosingMatcher<ConfigurableEnvironment>(){

            public void describeTo(Description description) {
                description.appendText("environment accepting profiles ").appendValue((Object)profiles);
            }

            protected boolean matchesSafely(ConfigurableEnvironment item, Description mismatchDescription) {
                mismatchDescription.appendText("Not matched against: ").appendValue((Object)item.getActiveProfiles());
                return item.acceptsProfiles(profiles);
            }
        };
    }

    @Configuration
    @PropertySource(value={"classpath:/specificlocation.properties", "classpath:/moreproperties.properties"}, name="foo")
    protected static class WithPropertySourceMultipleLocationsAndName {
        protected WithPropertySourceMultipleLocationsAndName() {
        }
    }

    @Configuration
    @PropertySource(value={"classpath:/specificlocation.properties", "classpath:/moreproperties.properties"})
    protected static class WithPropertySourceMultipleLocations {
        protected WithPropertySourceMultipleLocations() {
        }
    }

    @Configuration
    @PropertySource(value={"classpath:/enableprofile-myprofile.properties"})
    @Profile(value={"myprofile"})
    protected static class WithPropertySourceAndProfile {
        protected WithPropertySourceAndProfile() {
        }
    }

    @Configuration
    @PropertySource(value={"classpath:/enableprofile.properties"})
    protected static class WithPropertySourceInProfile {
        protected WithPropertySourceInProfile() {
        }
    }

    @Configuration
    @PropertySource(value={"classpath:/specificlocation.properties"}, name="foo")
    protected static class WithPropertySourceAndName {
        protected WithPropertySourceAndName() {
        }
    }

    @Configuration
    @PropertySource(value={"classpath:/${source.location}.properties"})
    protected static class WithPropertySourcePlaceholders {
        protected WithPropertySourcePlaceholders() {
        }
    }

    @Configuration
    @PropertySource(value={"classpath:/specificlocation.properties"})
    protected static class WithPropertySource {
        protected WithPropertySource() {
        }
    }

    @Configuration
    protected static class Config {
        protected Config() {
        }
    }
}

