/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.ansi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.springframework.boot.ansi.AnsiBackground;
import org.springframework.boot.ansi.AnsiColor;
import org.springframework.boot.ansi.AnsiElement;
import org.springframework.boot.ansi.AnsiOutput;
import org.springframework.boot.ansi.AnsiStyle;
import org.springframework.core.env.PropertySource;
import org.springframework.util.StringUtils;

public class AnsiPropertySource
extends PropertySource<AnsiElement> {
    private static final Iterable<MappedEnum<?>> MAPPED_ENUMS;
    private final boolean encode;

    public AnsiPropertySource(String name, boolean encode) {
        super(name);
        this.encode = encode;
    }

    public Object getProperty(String name) {
        if (StringUtils.hasLength((String)name)) {
            for (MappedEnum<?> mappedEnum : MAPPED_ENUMS) {
                if (!name.startsWith(mappedEnum.getPrefix())) continue;
                String enumName = name.substring(mappedEnum.getPrefix().length());
                for (Enum ansiEnum : mappedEnum.getEnums()) {
                    if (!ansiEnum.name().equals(enumName)) continue;
                    if (this.encode) {
                        return AnsiOutput.encode((AnsiElement)((Object)ansiEnum));
                    }
                    return ansiEnum;
                }
            }
        }
        return null;
    }

    static {
        ArrayList<MappedEnum<Enum>> enums = new ArrayList<MappedEnum<Enum>>();
        enums.add(new MappedEnum<AnsiStyle>("AnsiStyle.", AnsiStyle.class));
        enums.add(new MappedEnum<AnsiColor>("AnsiColor.", AnsiColor.class));
        enums.add(new MappedEnum<AnsiBackground>("AnsiBackground.", AnsiBackground.class));
        enums.add(new MappedEnum<AnsiStyle>("Ansi.", AnsiStyle.class));
        enums.add(new MappedEnum<AnsiColor>("Ansi.", AnsiColor.class));
        enums.add(new MappedEnum<AnsiBackground>("Ansi.BG_", AnsiBackground.class));
        MAPPED_ENUMS = Collections.unmodifiableList(enums);
    }

    private static class MappedEnum<E extends Enum<E>> {
        private final String prefix;
        private final Set<E> enums;

        public MappedEnum(String prefix, Class<E> enumType) {
            this.prefix = prefix;
            this.enums = EnumSet.allOf(enumType);
        }

        public String getPrefix() {
            return this.prefix;
        }

        public Set<E> getEnums() {
            return this.enums;
        }
    }
}

