/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.embedded.undertow;

import io.undertow.servlet.UndertowServletLogger;
import io.undertow.servlet.api.SessionPersistenceManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

public class FileSessionPersistence
implements SessionPersistenceManager {
    private final File folder;

    public FileSessionPersistence(File folder) {
        this.folder = folder;
    }

    public void persistSessions(String deploymentName, Map<String, SessionPersistenceManager.PersistentSession> sessionData) {
        try {
            this.save(sessionData, this.getSessionFile(deploymentName));
        }
        catch (Exception ex) {
            UndertowServletLogger.ROOT_LOGGER.failedToPersistSessions(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(Map<String, SessionPersistenceManager.PersistentSession> sessionData, File file) throws IOException {
        ObjectOutputStream stream = new ObjectOutputStream(new FileOutputStream(file));
        try {
            this.save(sessionData, stream);
        }
        finally {
            stream.close();
        }
    }

    private void save(Map<String, SessionPersistenceManager.PersistentSession> sessionData, ObjectOutputStream stream) throws IOException {
        LinkedHashMap<String, SerializablePersistentSession> session = new LinkedHashMap<String, SerializablePersistentSession>();
        for (Map.Entry<String, SessionPersistenceManager.PersistentSession> entry : sessionData.entrySet()) {
            session.put(entry.getKey(), new SerializablePersistentSession(entry.getValue()));
        }
        stream.writeObject(session);
    }

    public Map<String, SessionPersistenceManager.PersistentSession> loadSessionAttributes(String deploymentName, ClassLoader classLoader) {
        try {
            File file = this.getSessionFile(deploymentName);
            if (file.exists()) {
                return this.load(file);
            }
        }
        catch (Exception ex) {
            UndertowServletLogger.ROOT_LOGGER.failedtoLoadPersistentSessions(ex);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, SessionPersistenceManager.PersistentSession> load(File file) throws IOException, ClassNotFoundException {
        ObjectInputStream stream = new ObjectInputStream(new FileInputStream(file));
        try {
            Map<String, SessionPersistenceManager.PersistentSession> map = this.load(stream);
            return map;
        }
        finally {
            stream.close();
        }
    }

    private Map<String, SessionPersistenceManager.PersistentSession> load(ObjectInputStream stream) throws ClassNotFoundException, IOException {
        Map<String, SerializablePersistentSession> session = this.readSession(stream);
        long time = System.currentTimeMillis();
        LinkedHashMap<String, SessionPersistenceManager.PersistentSession> result = new LinkedHashMap<String, SessionPersistenceManager.PersistentSession>();
        for (Map.Entry<String, SerializablePersistentSession> entry : session.entrySet()) {
            SessionPersistenceManager.PersistentSession entrySession = entry.getValue().getPersistentSession();
            if (entrySession.getExpiration().getTime() <= time) continue;
            result.put(entry.getKey(), entrySession);
        }
        return result;
    }

    private Map<String, SerializablePersistentSession> readSession(ObjectInputStream stream) throws ClassNotFoundException, IOException {
        return (Map)stream.readObject();
    }

    private File getSessionFile(String deploymentName) {
        if (!this.folder.exists()) {
            this.folder.mkdirs();
        }
        return new File(this.folder, deploymentName + ".session");
    }

    public void clear(String deploymentName) {
        this.getSessionFile(deploymentName).delete();
    }

    static class SerializablePersistentSession
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private final Date expiration;
        private final Map<String, Object> sessionData;

        SerializablePersistentSession(SessionPersistenceManager.PersistentSession session) {
            this.expiration = session.getExpiration();
            this.sessionData = new LinkedHashMap<String, Object>(session.getSessionData());
        }

        public SessionPersistenceManager.PersistentSession getPersistentSession() {
            return new SessionPersistenceManager.PersistentSession(this.expiration, this.sessionData);
        }
    }
}

