/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.embedded.jetty;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.ForwardedRequestCustomizer;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.session.HashSessionManager;
import org.eclipse.jetty.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlet.ServletMapping;
import org.eclipse.jetty.servlets.gzip.GzipHandler;
import org.eclipse.jetty.util.resource.JarResource;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.webapp.AbstractConfiguration;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.springframework.boot.context.embedded.AbstractEmbeddedServletContainerFactory;
import org.springframework.boot.context.embedded.Compression;
import org.springframework.boot.context.embedded.EmbeddedServletContainer;
import org.springframework.boot.context.embedded.EmbeddedServletContainerException;
import org.springframework.boot.context.embedded.ErrorPage;
import org.springframework.boot.context.embedded.MimeMappings;
import org.springframework.boot.context.embedded.ServletContextInitializer;
import org.springframework.boot.context.embedded.Ssl;
import org.springframework.boot.context.embedded.jetty.JettyEmbeddedServletContainer;
import org.springframework.boot.context.embedded.jetty.JettyEmbeddedWebAppContext;
import org.springframework.boot.context.embedded.jetty.JettyServerCustomizer;
import org.springframework.boot.context.embedded.jetty.ServletContextInitializerConfiguration;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;

public class JettyEmbeddedServletContainerFactory
extends AbstractEmbeddedServletContainerFactory
implements ResourceLoaderAware {
    private static final String GZIP_HANDLER_JETTY_9_2 = "org.eclipse.jetty.servlets.gzip.GzipHandler";
    private static final String GZIP_HANDLER_JETTY_8 = "org.eclipse.jetty.server.handler.GzipHandler";
    private static final String GZIP_HANDLER_JETTY_9_3 = "org.eclipse.jetty.server.handler.gzip.GzipHandler";
    private List<Configuration> configurations = new ArrayList<Configuration>();
    private boolean useForwardHeaders;
    private List<JettyServerCustomizer> jettyServerCustomizers = new ArrayList<JettyServerCustomizer>();
    private ResourceLoader resourceLoader;

    public JettyEmbeddedServletContainerFactory() {
    }

    public JettyEmbeddedServletContainerFactory(int port) {
        super(port);
    }

    public JettyEmbeddedServletContainerFactory(String contextPath, int port) {
        super(contextPath, port);
    }

    @Override
    public EmbeddedServletContainer getEmbeddedServletContainer(ServletContextInitializer ... initializers) {
        JettyEmbeddedWebAppContext context = new JettyEmbeddedWebAppContext();
        int port = this.getPort() >= 0 ? this.getPort() : 0;
        Server server = new Server(new InetSocketAddress(this.getAddress(), port));
        this.configureWebAppContext(context, initializers);
        server.setHandler(this.addHandlerWrappers((Handler)context));
        this.logger.info((Object)("Server initialized with port: " + port));
        if (this.getSsl() != null && this.getSsl().isEnabled()) {
            SslContextFactory sslContextFactory = new SslContextFactory();
            this.configureSsl(sslContextFactory, this.getSsl());
            AbstractConnector connector = this.getSslServerConnectorFactory().getConnector(server, sslContextFactory, port);
            server.setConnectors(new Connector[]{connector});
        }
        for (JettyServerCustomizer customizer : this.getServerCustomizers()) {
            customizer.customize(server);
        }
        if (this.useForwardHeaders) {
            new ForwardHeadersCustomizer().customize(server);
        }
        return this.getJettyEmbeddedServletContainer(server);
    }

    private Handler addHandlerWrappers(Handler handler) {
        if (this.getCompression() != null && this.getCompression().getEnabled()) {
            handler = this.applyWrapper(handler, this.createGzipHandler());
        }
        if (StringUtils.hasText((String)this.getServerHeader())) {
            handler = this.applyWrapper(handler, new ServerHeaderHandler(this.getServerHeader()));
        }
        return handler;
    }

    private Handler applyWrapper(Handler handler, HandlerWrapper wrapper) {
        wrapper.setHandler(handler);
        return wrapper;
    }

    private HandlerWrapper createGzipHandler() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (ClassUtils.isPresent((String)GZIP_HANDLER_JETTY_9_2, (ClassLoader)classLoader)) {
            return new Jetty92GzipHandlerFactory().createGzipHandler(this.getCompression());
        }
        if (ClassUtils.isPresent((String)GZIP_HANDLER_JETTY_8, (ClassLoader)this.getClass().getClassLoader())) {
            return new Jetty8GzipHandlerFactory().createGzipHandler(this.getCompression());
        }
        if (ClassUtils.isPresent((String)GZIP_HANDLER_JETTY_9_3, (ClassLoader)this.getClass().getClassLoader())) {
            return new Jetty93GzipHandlerFactory().createGzipHandler(this.getCompression());
        }
        throw new IllegalStateException("Compression is enabled, but GzipHandler is not on the classpath");
    }

    private SslServerConnectorFactory getSslServerConnectorFactory() {
        if (ClassUtils.isPresent((String)"org.eclipse.jetty.server.ssl.SslSocketConnector", null)) {
            return new Jetty8SslServerConnectorFactory();
        }
        return new Jetty9SslServerConnectorFactory();
    }

    protected void configureSsl(SslContextFactory factory, Ssl ssl) {
        factory.setProtocol(ssl.getProtocol());
        this.configureSslClientAuth(factory, ssl);
        this.configureSslPasswords(factory, ssl);
        factory.setCertAlias(ssl.getKeyAlias());
        this.configureSslKeyStore(factory, ssl);
        if (ssl.getCiphers() != null) {
            factory.setIncludeCipherSuites(ssl.getCiphers());
        }
        if (ssl.getEnabledProtocols() != null) {
            factory.setIncludeProtocols(ssl.getEnabledProtocols());
        }
        this.configureSslTrustStore(factory, ssl);
    }

    private void configureSslClientAuth(SslContextFactory factory, Ssl ssl) {
        if (ssl.getClientAuth() == Ssl.ClientAuth.NEED) {
            factory.setNeedClientAuth(true);
            factory.setWantClientAuth(true);
        } else if (ssl.getClientAuth() == Ssl.ClientAuth.WANT) {
            factory.setWantClientAuth(true);
        }
    }

    private void configureSslPasswords(SslContextFactory factory, Ssl ssl) {
        if (ssl.getKeyStorePassword() != null) {
            factory.setKeyStorePassword(ssl.getKeyStorePassword());
        }
        if (ssl.getKeyPassword() != null) {
            factory.setKeyManagerPassword(ssl.getKeyPassword());
        }
    }

    private void configureSslKeyStore(SslContextFactory factory, Ssl ssl) {
        try {
            URL url = ResourceUtils.getURL((String)ssl.getKeyStore());
            factory.setKeyStoreResource(Resource.newResource((URL)url));
        }
        catch (IOException ex) {
            throw new EmbeddedServletContainerException("Could not find key store '" + ssl.getKeyStore() + "'", ex);
        }
        if (ssl.getKeyStoreType() != null) {
            factory.setKeyStoreType(ssl.getKeyStoreType());
        }
        if (ssl.getKeyStoreProvider() != null) {
            factory.setKeyStoreProvider(ssl.getKeyStoreProvider());
        }
    }

    private void configureSslTrustStore(SslContextFactory factory, Ssl ssl) {
        if (ssl.getTrustStorePassword() != null) {
            factory.setTrustStorePassword(ssl.getTrustStorePassword());
        }
        if (ssl.getTrustStore() != null) {
            try {
                URL url = ResourceUtils.getURL((String)ssl.getTrustStore());
                factory.setTrustStoreResource(Resource.newResource((URL)url));
            }
            catch (IOException ex) {
                throw new EmbeddedServletContainerException("Could not find trust store '" + ssl.getTrustStore() + "'", ex);
            }
        }
        if (ssl.getTrustStoreType() != null) {
            factory.setTrustStoreType(ssl.getTrustStoreType());
        }
        if (ssl.getTrustStoreProvider() != null) {
            factory.setTrustStoreProvider(ssl.getTrustStoreProvider());
        }
    }

    protected final void configureWebAppContext(WebAppContext context, ServletContextInitializer ... initializers) {
        String contextPath;
        Assert.notNull((Object)context, (String)"Context must not be null");
        context.setTempDirectory(this.getTempDirectory());
        if (this.resourceLoader != null) {
            context.setClassLoader(this.resourceLoader.getClassLoader());
        }
        context.setContextPath(StringUtils.hasLength((String)(contextPath = this.getContextPath())) ? contextPath : "/");
        context.setDisplayName(this.getDisplayName());
        this.configureDocumentRoot(context);
        if (this.isRegisterDefaultServlet()) {
            this.addDefaultServlet(context);
        }
        if (this.shouldRegisterJspServlet()) {
            this.addJspServlet(context);
        }
        ServletContextInitializer[] initializersToUse = this.mergeInitializers(initializers);
        Configuration[] configurations = this.getWebAppContextConfigurations(context, initializersToUse);
        context.setConfigurations(configurations);
        this.configureSession(context);
        this.postProcessWebAppContext(context);
    }

    private void configureSession(WebAppContext context) {
        SessionManager sessionManager = context.getSessionHandler().getSessionManager();
        int sessionTimeout = this.getSessionTimeout() > 0 ? this.getSessionTimeout() : -1;
        sessionManager.setMaxInactiveInterval(sessionTimeout);
        if (this.isPersistSession()) {
            Assert.isInstanceOf(HashSessionManager.class, (Object)sessionManager, (String)"Unable to use persistent sessions");
            this.configurePersistSession(sessionManager);
        }
    }

    private void configurePersistSession(SessionManager sessionManager) {
        try {
            ((HashSessionManager)sessionManager).setStoreDirectory(this.getValidSessionStoreDir());
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private File getTempDirectory() {
        String temp = System.getProperty("java.io.tmpdir");
        return temp == null ? null : new File(temp);
    }

    private void configureDocumentRoot(WebAppContext handler) {
        File root = this.getValidDocumentRoot();
        root = root != null ? root : this.createTempDir("jetty-docbase");
        try {
            if (!root.isDirectory()) {
                Resource resource = JarResource.newJarResource((Resource)Resource.newResource((File)root));
                handler.setBaseResource(resource);
            } else {
                handler.setBaseResource(Resource.newResource((File)root.getCanonicalFile()));
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    protected final void addDefaultServlet(WebAppContext context) {
        Assert.notNull((Object)context, (String)"Context must not be null");
        ServletHolder holder = new ServletHolder();
        holder.setName("default");
        holder.setClassName("org.eclipse.jetty.servlet.DefaultServlet");
        holder.setInitParameter("dirAllowed", "false");
        holder.setInitOrder(1);
        context.getServletHandler().addServletWithMapping(holder, "/");
        context.getServletHandler().getServletMapping("/").setDefault(true);
    }

    protected final void addJspServlet(WebAppContext context) {
        Assert.notNull((Object)context, (String)"Context must not be null");
        ServletHolder holder = new ServletHolder();
        holder.setName("jsp");
        holder.setClassName(this.getJspServlet().getClassName());
        holder.setInitParameter("fork", "false");
        holder.setInitParameters(this.getJspServlet().getInitParameters());
        holder.setInitOrder(3);
        context.getServletHandler().addServlet(holder);
        ServletMapping mapping = new ServletMapping();
        mapping.setServletName("jsp");
        mapping.setPathSpecs(new String[]{"*.jsp", "*.jspx"});
        context.getServletHandler().addServletMapping(mapping);
    }

    protected Configuration[] getWebAppContextConfigurations(WebAppContext webAppContext, ServletContextInitializer ... initializers) {
        ArrayList<Configuration> configurations = new ArrayList<Configuration>();
        configurations.add(this.getServletContextInitializerConfiguration(webAppContext, initializers));
        configurations.addAll(this.getConfigurations());
        configurations.add(this.getErrorPageConfiguration());
        configurations.add(this.getMimeTypeConfiguration());
        return configurations.toArray(new Configuration[configurations.size()]);
    }

    private Configuration getErrorPageConfiguration() {
        return new AbstractConfiguration(){

            public void configure(WebAppContext context) throws Exception {
                ErrorHandler errorHandler = context.getErrorHandler();
                JettyEmbeddedServletContainerFactory.this.addJettyErrorPages(errorHandler, JettyEmbeddedServletContainerFactory.this.getErrorPages());
            }
        };
    }

    private Configuration getMimeTypeConfiguration() {
        return new AbstractConfiguration(){

            public void configure(WebAppContext context) throws Exception {
                MimeTypes mimeTypes = context.getMimeTypes();
                for (MimeMappings.Mapping mapping : JettyEmbeddedServletContainerFactory.this.getMimeMappings()) {
                    mimeTypes.addMimeMapping(mapping.getExtension(), mapping.getMimeType());
                }
            }
        };
    }

    protected Configuration getServletContextInitializerConfiguration(WebAppContext webAppContext, ServletContextInitializer ... initializers) {
        return new ServletContextInitializerConfiguration(initializers);
    }

    protected void postProcessWebAppContext(WebAppContext webAppContext) {
    }

    protected JettyEmbeddedServletContainer getJettyEmbeddedServletContainer(Server server) {
        return new JettyEmbeddedServletContainer(server, this.getPort() >= 0);
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setUseForwardHeaders(boolean useForwardHeaders) {
        this.useForwardHeaders = useForwardHeaders;
    }

    public void setServerCustomizers(Collection<? extends JettyServerCustomizer> customizers) {
        Assert.notNull(customizers, (String)"Customizers must not be null");
        this.jettyServerCustomizers = new ArrayList<JettyServerCustomizer>(customizers);
    }

    public Collection<JettyServerCustomizer> getServerCustomizers() {
        return this.jettyServerCustomizers;
    }

    public void addServerCustomizers(JettyServerCustomizer ... customizers) {
        Assert.notNull((Object)customizers, (String)"Customizers must not be null");
        this.jettyServerCustomizers.addAll(Arrays.asList(customizers));
    }

    public void setConfigurations(Collection<? extends Configuration> configurations) {
        Assert.notNull(configurations, (String)"Configurations must not be null");
        this.configurations = new ArrayList<Configuration>(configurations);
    }

    public Collection<Configuration> getConfigurations() {
        return this.configurations;
    }

    public void addConfigurations(Configuration ... configurations) {
        Assert.notNull((Object)configurations, (String)"Configurations must not be null");
        this.configurations.addAll(Arrays.asList(configurations));
    }

    private void addJettyErrorPages(ErrorHandler errorHandler, Collection<ErrorPage> errorPages) {
        if (errorHandler instanceof ErrorPageErrorHandler) {
            ErrorPageErrorHandler handler = (ErrorPageErrorHandler)errorHandler;
            for (ErrorPage errorPage : errorPages) {
                if (errorPage.isGlobal()) {
                    handler.addErrorPage("org.eclipse.jetty.server.error_page.global", errorPage.getPath());
                    continue;
                }
                if (errorPage.getExceptionName() != null) {
                    handler.addErrorPage(errorPage.getExceptionName(), errorPage.getPath());
                    continue;
                }
                handler.addErrorPage(errorPage.getStatusCode(), errorPage.getPath());
            }
        }
    }

    private static class ServerHeaderHandler
    extends HandlerWrapper {
        private static final String SERVER_HEADER = "server";
        private final String value;

        ServerHeaderHandler(String value) {
            this.value = value;
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            if (!response.getHeaderNames().contains(SERVER_HEADER)) {
                response.setHeader(SERVER_HEADER, this.value);
            }
            super.handle(target, baseRequest, request, response);
        }
    }

    private static class ForwardHeadersCustomizer
    implements JettyServerCustomizer {
        private ForwardHeadersCustomizer() {
        }

        @Override
        public void customize(Server server) {
            ForwardedRequestCustomizer customizer = new ForwardedRequestCustomizer();
            for (Connector connector : server.getConnectors()) {
                for (ConnectionFactory connectionFactory : connector.getConnectionFactories()) {
                    if (!(connectionFactory instanceof HttpConfiguration.ConnectionFactory)) continue;
                    ((HttpConfiguration.ConnectionFactory)connectionFactory).getHttpConfiguration().addCustomizer((HttpConfiguration.Customizer)customizer);
                }
            }
        }
    }

    private static class Jetty93GzipHandlerFactory
    implements GzipHandlerFactory {
        private Jetty93GzipHandlerFactory() {
        }

        @Override
        public HandlerWrapper createGzipHandler(Compression compression) {
            try {
                Class handlerClass = ClassUtils.forName((String)JettyEmbeddedServletContainerFactory.GZIP_HANDLER_JETTY_9_3, (ClassLoader)this.getClass().getClassLoader());
                HandlerWrapper handler = (HandlerWrapper)handlerClass.newInstance();
                ReflectionUtils.findMethod((Class)handlerClass, (String)"setMinGzipSize", (Class[])new Class[]{Integer.TYPE}).invoke((Object)handler, compression.getMinResponseSize());
                ReflectionUtils.findMethod((Class)handlerClass, (String)"setIncludedMimeTypes", (Class[])new Class[]{String[].class}).invoke((Object)handler, new Object[]{compression.getMimeTypes()});
                if (compression.getExcludedUserAgents() != null) {
                    ReflectionUtils.findMethod((Class)handlerClass, (String)"setExcludedAgentPatterns", (Class[])new Class[]{String[].class}).invoke((Object)handler, new Object[]{compression.getExcludedUserAgents()});
                }
                return handler;
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to configure Jetty 9.3 gzip handler", ex);
            }
        }
    }

    private static class Jetty92GzipHandlerFactory
    implements GzipHandlerFactory {
        private Jetty92GzipHandlerFactory() {
        }

        @Override
        public HandlerWrapper createGzipHandler(Compression compression) {
            GzipHandler gzipHandler = new GzipHandler();
            gzipHandler.setMinGzipSize(compression.getMinResponseSize());
            gzipHandler.addIncludedMimeTypes(compression.getMimeTypes());
            if (compression.getExcludedUserAgents() != null) {
                gzipHandler.setExcluded(new HashSet<String>(Arrays.asList(compression.getExcludedUserAgents())));
            }
            return gzipHandler;
        }
    }

    private static class Jetty8GzipHandlerFactory
    implements GzipHandlerFactory {
        private Jetty8GzipHandlerFactory() {
        }

        @Override
        public HandlerWrapper createGzipHandler(Compression compression) {
            try {
                Class handlerClass = ClassUtils.forName((String)JettyEmbeddedServletContainerFactory.GZIP_HANDLER_JETTY_8, (ClassLoader)this.getClass().getClassLoader());
                HandlerWrapper handler = (HandlerWrapper)handlerClass.newInstance();
                ReflectionUtils.findMethod((Class)handlerClass, (String)"setMinGzipSize", (Class[])new Class[]{Integer.TYPE}).invoke((Object)handler, compression.getMinResponseSize());
                ReflectionUtils.findMethod((Class)handlerClass, (String)"setMimeTypes", (Class[])new Class[]{Set.class}).invoke((Object)handler, new HashSet<String>(Arrays.asList(compression.getMimeTypes())));
                if (compression.getExcludedUserAgents() != null) {
                    ReflectionUtils.findMethod((Class)handlerClass, (String)"setExcluded", (Class[])new Class[]{Set.class}).invoke((Object)handler, new HashSet<String>(Arrays.asList(compression.getExcludedUserAgents())));
                }
                return handler;
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to configure Jetty 8 gzip handler", ex);
            }
        }
    }

    private static interface GzipHandlerFactory {
        public HandlerWrapper createGzipHandler(Compression var1);
    }

    private static class Jetty8SslServerConnectorFactory
    implements SslServerConnectorFactory {
        private Jetty8SslServerConnectorFactory() {
        }

        @Override
        public AbstractConnector getConnector(Server server, SslContextFactory sslContextFactory, int port) {
            try {
                Class<?> connectorClass = Class.forName("org.eclipse.jetty.server.ssl.SslSocketConnector");
                AbstractConnector connector = (AbstractConnector)connectorClass.getConstructor(SslContextFactory.class).newInstance(sslContextFactory);
                connector.getClass().getMethod("setPort", Integer.TYPE).invoke((Object)connector, port);
                return connector;
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    private static class Jetty9SslServerConnectorFactory
    implements SslServerConnectorFactory {
        private Jetty9SslServerConnectorFactory() {
        }

        public ServerConnector getConnector(Server server, SslContextFactory sslContextFactory, int port) {
            HttpConfiguration config = new HttpConfiguration();
            config.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
            HttpConnectionFactory connectionFactory = new HttpConnectionFactory(config);
            SslConnectionFactory sslConnectionFactory = new SslConnectionFactory(sslContextFactory, HttpVersion.HTTP_1_1.asString());
            ServerConnector serverConnector = new ServerConnector(server, new ConnectionFactory[]{sslConnectionFactory, connectionFactory});
            serverConnector.setPort(port);
            return serverConnector;
        }
    }

    private static interface SslServerConnectorFactory {
        public AbstractConnector getConnector(Server var1, SslContextFactory var2, int var3);
    }
}

