/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.diagnostics.analyzer;

import java.util.ArrayList;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanCurrentlyInCreationException;
import org.springframework.boot.diagnostics.AbstractFailureAnalyzer;
import org.springframework.boot.diagnostics.FailureAnalysis;
import org.springframework.util.StringUtils;

class BeanCurrentlyInCreationFailureAnalyzer
extends AbstractFailureAnalyzer<BeanCurrentlyInCreationException> {
    private static final String FIELD_AUTOWIRING_FAILURE_MESSAGE_PREFIX = "Could not autowire field: ";

    BeanCurrentlyInCreationFailureAnalyzer() {
    }

    @Override
    protected FailureAnalysis analyze(Throwable rootFailure, BeanCurrentlyInCreationException cause) {
        ArrayList<String> beansInCycle = new ArrayList<String>();
        for (Throwable candidate = rootFailure; candidate != null; candidate = candidate.getCause()) {
            BeanCreationException creationEx;
            if (!(candidate instanceof BeanCreationException) || !StringUtils.hasText((String)(creationEx = (BeanCreationException)candidate).getBeanName())) continue;
            beansInCycle.add(creationEx.getBeanName() + this.getDescription(creationEx));
        }
        StringBuilder message = new StringBuilder();
        int uniqueBeans = beansInCycle.size() - 1;
        message.append(String.format("There is a circular dependency between %s beans in the application context:%n", uniqueBeans));
        for (String bean : beansInCycle) {
            message.append(String.format("\t- %s%n", bean));
        }
        return new FailureAnalysis(message.toString(), null, (Throwable)cause);
    }

    private String getDescription(BeanCreationException ex) {
        if (StringUtils.hasText((String)ex.getResourceDescription())) {
            return String.format(" defined in %s", ex.getResourceDescription());
        }
        if (this.causedByFieldAutowiringFailure(ex)) {
            return String.format(" (field %s)", ex.getCause().getMessage().substring(FIELD_AUTOWIRING_FAILURE_MESSAGE_PREFIX.length(), ex.getCause().getMessage().indexOf(";")));
        }
        return "";
    }

    private boolean causedByFieldAutowiringFailure(BeanCreationException ex) {
        return ex.getCause() instanceof BeanCreationException && ex.getCause().getMessage().startsWith(FIELD_AUTOWIRING_FAILURE_MESSAGE_PREFIX);
    }
}

