/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.neo4j;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.boot.context.scan.AbstractEntityScanBeanPostProcessor;
import org.springframework.boot.context.scan.AbstractEntityScanRegistrar;
import org.springframework.boot.neo4j.NodeEntityScan;
import org.springframework.boot.neo4j.SessionFactoryProvider;
import org.springframework.util.Assert;

class NodeEntityScanRegistrar
extends AbstractEntityScanRegistrar {
    NodeEntityScanRegistrar() {
        super(NodeEntityScan.class, "nodeEntityScanBeanPostProcessor", NodeEntityScanBeanPostProcessor.class);
    }

    static class NodeEntityScanBeanPostProcessor
    extends AbstractEntityScanBeanPostProcessor
    implements SmartInitializingSingleton {
        private boolean processed;

        NodeEntityScanBeanPostProcessor(String[] packagesToScan) {
            super(packagesToScan);
        }

        public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
            if (bean instanceof SessionFactoryProvider) {
                SessionFactoryProvider provider = (SessionFactoryProvider)bean;
                provider.setPackagesToScan(this.getPackagesToScan());
                this.processed = true;
            }
            return bean;
        }

        public void afterSingletonsInstantiated() {
            Assert.state((boolean)this.processed, (String)"Unable to configure SessionFactoryFactoryBean from @NodeEntityScan, ensure an appropriate bean is registered.");
        }
    }
}

