/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.orm.jpa;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.boot.context.scan.AbstractEntityScanBeanPostProcessor;
import org.springframework.boot.context.scan.AbstractEntityScanRegistrar;
import org.springframework.boot.orm.jpa.EntityScan;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.util.Assert;

class JpaEntityScanRegistrar
extends AbstractEntityScanRegistrar {
    JpaEntityScanRegistrar() {
        super(EntityScan.class, "entityScanBeanPostProcessor", JpaEntityScanBeanPostProcessor.class);
    }

    static class JpaEntityScanBeanPostProcessor
    extends AbstractEntityScanBeanPostProcessor
    implements SmartInitializingSingleton {
        private boolean processed;

        JpaEntityScanBeanPostProcessor(String[] packagesToScan) {
            super(packagesToScan);
        }

        public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
            if (bean instanceof LocalContainerEntityManagerFactoryBean) {
                LocalContainerEntityManagerFactoryBean factoryBean = (LocalContainerEntityManagerFactoryBean)bean;
                factoryBean.setPackagesToScan(this.getPackagesToScan());
                this.processed = true;
            }
            return bean;
        }

        public void afterSingletonsInstantiated() {
            Assert.state((boolean)this.processed, (String)"Unable to configure LocalContainerEntityManagerFactoryBean from @EntityScan, ensure an appropriate bean is registered.");
        }
    }
}

