/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.bind;

import java.util.Collection;
import org.springframework.boot.context.properties.bind.AggregateElementBinder;
import org.springframework.boot.context.properties.bind.BindContext;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.IndexedElementsBinder;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.core.CollectionFactory;
import org.springframework.core.ResolvableType;

class CollectionBinder
extends IndexedElementsBinder<Collection<Object>> {
    CollectionBinder(BindContext context) {
        super(context);
    }

    @Override
    protected Object bind(ConfigurationPropertyName name, Bindable<?> target, AggregateElementBinder elementBinder, Class<?> type) {
        IndexedElementsBinder.IndexedCollectionSupplier collection = new IndexedElementsBinder.IndexedCollectionSupplier(() -> CollectionFactory.createCollection((Class)type, (int)0));
        ResolvableType elementType = target.getType().asCollection().getGeneric(new int[0]);
        this.bindIndexed(name, target, elementBinder, collection, target.getType(), elementType);
        if (collection.wasSupplied()) {
            return collection.get();
        }
        return null;
    }

    @Override
    protected Collection<Object> merge(Collection<Object> existing, Collection<Object> additional) {
        existing.clear();
        existing.addAll(additional);
        return existing;
    }
}

