/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.bind.validation;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.boot.context.properties.bind.AbstractBindHandler;
import org.springframework.boot.context.properties.bind.BindContext;
import org.springframework.boot.context.properties.bind.BindHandler;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.validation.BindValidationException;
import org.springframework.boot.context.properties.bind.validation.ValidationErrors;
import org.springframework.boot.context.properties.source.ConfigurationProperty;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.springframework.validation.annotation.Validated;

public class ValidationBindHandler
extends AbstractBindHandler {
    private final Validator[] validators;
    private boolean validate;
    private final Set<ConfigurationProperty> boundProperties = new LinkedHashSet<ConfigurationProperty>();

    public ValidationBindHandler(Validator ... validators) {
        this.validators = validators;
    }

    public ValidationBindHandler(BindHandler parent, Validator ... validators) {
        super(parent);
        this.validators = validators;
    }

    @Override
    public boolean onStart(ConfigurationPropertyName name, Bindable<?> target, BindContext context) {
        if (context.getDepth() == 0) {
            this.validate = this.shouldValidate(target);
        }
        return super.onStart(name, target, context);
    }

    private boolean shouldValidate(Bindable<?> target) {
        Validated annotation = (Validated)AnnotationUtils.findAnnotation((Class)target.getBoxedType().resolve(), Validated.class);
        return annotation != null;
    }

    @Override
    public Object onSuccess(ConfigurationPropertyName name, Bindable<?> target, BindContext context, Object result) {
        if (context.getConfigurationProperty() != null) {
            this.boundProperties.add(context.getConfigurationProperty());
        }
        return super.onSuccess(name, target, context, result);
    }

    @Override
    public void onFinish(ConfigurationPropertyName name, Bindable<?> target, BindContext context, Object result) throws Exception {
        if (this.validate) {
            this.validate(name, target, result);
        }
        super.onFinish(name, target, context, result);
    }

    private void validate(ConfigurationPropertyName name, Bindable<?> target, Object result) {
        Object validationTarget = this.getValidationTarget(target, result);
        Class validationType = target.getBoxedType().resolve();
        this.validate(name, validationTarget, validationType);
    }

    private Object getValidationTarget(Bindable<?> target, Object result) {
        if (result != null) {
            return result;
        }
        if (target.getValue() != null) {
            return target.getValue().get();
        }
        return null;
    }

    private void validate(ConfigurationPropertyName name, Object target, Class<?> type) {
        if (target != null) {
            BeanPropertyBindingResult errors = new BeanPropertyBindingResult(target, name.toString());
            Arrays.stream(this.validators).filter(v -> v.supports(type)).forEach(arg_0 -> ValidationBindHandler.lambda$validate$1(target, (BindingResult)errors, arg_0));
            if (errors.hasErrors()) {
                this.throwBindValidationException(name, (BindingResult)errors);
            }
        }
    }

    private void throwBindValidationException(ConfigurationPropertyName name, BindingResult errors) {
        Set boundProperties = this.boundProperties.stream().filter(property -> name.isAncestorOf(property.getName())).collect(Collectors.toCollection(LinkedHashSet::new));
        ValidationErrors validationErrors = new ValidationErrors(name, boundProperties, errors.getAllErrors());
        throw new BindValidationException(validationErrors);
    }

    private static /* synthetic */ void lambda$validate$1(Object target, BindingResult errors, Validator v) {
        v.validate(target, (Errors)errors);
    }
}

