/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.embedded.jetty;

import java.net.InetSocketAddress;
import javax.servlet.Servlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.springframework.boot.web.embedded.jetty.JettyWebServer;
import org.springframework.boot.web.reactive.server.AbstractReactiveWebServerFactory;
import org.springframework.boot.web.server.WebServer;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.http.server.reactive.JettyHttpHandlerAdapter;

public class JettyReactiveWebServerFactory
extends AbstractReactiveWebServerFactory {
    private static final Log logger = LogFactory.getLog(JettyReactiveWebServerFactory.class);
    private int acceptors = -1;
    private int selectors = -1;
    private ThreadPool threadPool;

    public JettyReactiveWebServerFactory() {
    }

    public JettyReactiveWebServerFactory(int port) {
        super(port);
    }

    @Override
    public WebServer getWebServer(HttpHandler httpHandler) {
        JettyHttpHandlerAdapter servlet = new JettyHttpHandlerAdapter(httpHandler);
        Server server = this.createJettyServer(servlet);
        return new JettyWebServer(server, this.getPort() >= 0);
    }

    protected Server createJettyServer(JettyHttpHandlerAdapter servlet) {
        int port = this.getPort() >= 0 ? this.getPort() : 0;
        InetSocketAddress address = new InetSocketAddress(this.getAddress(), port);
        Server server = new Server(this.getThreadPool());
        server.addConnector((Connector)this.createConnector(address, server));
        ServletHolder servletHolder = new ServletHolder((Servlet)servlet);
        ServletContextHandler contextHandler = new ServletContextHandler((HandlerContainer)server, "", false, false);
        contextHandler.addServlet(servletHolder, "/");
        logger.info((Object)("Server initialized with port: " + port));
        return server;
    }

    private AbstractConnector createConnector(InetSocketAddress address, Server server) {
        ServerConnector connector = new ServerConnector(server, this.acceptors, this.selectors);
        connector.setHost(address.getHostName());
        connector.setPort(address.getPort());
        for (ConnectionFactory connectionFactory : connector.getConnectionFactories()) {
            if (!(connectionFactory instanceof HttpConfiguration.ConnectionFactory)) continue;
            ((HttpConfiguration.ConnectionFactory)connectionFactory).getHttpConfiguration().setSendServerVersion(false);
        }
        return connector;
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    public void setThreadPool(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    public void setAcceptors(int acceptors) {
        this.acceptors = acceptors;
    }

    public void setSelectors(int selectors) {
        this.selectors = selectors;
    }
}

