/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.embedded.netty;

import java.net.BindException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.web.server.WebServer;
import org.springframework.boot.web.server.WebServerException;
import org.springframework.http.server.reactive.ReactorHttpHandlerAdapter;
import reactor.ipc.netty.NettyContext;
import reactor.ipc.netty.http.server.HttpServer;

public class NettyWebServer
implements WebServer {
    private static final Log logger = LogFactory.getLog(NettyWebServer.class);
    private CountDownLatch latch;
    private final ReactorHttpHandlerAdapter handlerAdapter;
    private final HttpServer reactorServer;
    private AtomicReference<NettyContext> nettyContext = new AtomicReference();

    public NettyWebServer(HttpServer reactorServer, ReactorHttpHandlerAdapter handlerAdapter) {
        this.reactorServer = reactorServer;
        this.handlerAdapter = handlerAdapter;
    }

    @Override
    public void start() throws WebServerException {
        if (this.nettyContext.get() == null) {
            this.latch = new CountDownLatch(1);
            try {
                this.nettyContext.set((NettyContext)this.reactorServer.newHandler((BiFunction)this.handlerAdapter).block());
            }
            catch (Exception ex) {
                if (this.findBindException(ex) != null) {
                    // empty if block
                }
                throw new WebServerException("Unable to start Netty", ex);
            }
            logger.info((Object)("Netty started on port(s): " + this.getPort()));
            this.startDaemonAwaitThread();
        }
    }

    private BindException findBindException(Exception ex) {
        for (Throwable candidate = ex; candidate != null; candidate = candidate.getCause()) {
            if (!(candidate instanceof BindException)) continue;
            return (BindException)candidate;
        }
        return null;
    }

    private void startDaemonAwaitThread() {
        Thread awaitThread = new Thread("server"){

            @Override
            public void run() {
                try {
                    NettyWebServer.this.latch.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        awaitThread.setContextClassLoader(this.getClass().getClassLoader());
        awaitThread.setDaemon(false);
        awaitThread.start();
    }

    @Override
    public void stop() throws WebServerException {
        NettyContext context = this.nettyContext.getAndSet(null);
        if (context != null) {
            context.dispose();
        }
        this.latch.countDown();
    }

    @Override
    public int getPort() {
        if (this.nettyContext.get() != null) {
            return this.nettyContext.get().address().getPort();
        }
        return 0;
    }
}

