/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.source;

import java.util.ArrayList;
import java.util.function.Function;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public final class ConfigurationPropertyName
implements Comparable<ConfigurationPropertyName> {
    private static final String EMPTY_STRING = "";
    public static final ConfigurationPropertyName EMPTY = new ConfigurationPropertyName(new String[0]);
    private final CharSequence[] elements;
    private final CharSequence[] uniformElements;
    private int[] elementHashCodes;
    private String string;

    private ConfigurationPropertyName(CharSequence[] elements) {
        this(elements, new CharSequence[elements.length]);
    }

    private ConfigurationPropertyName(CharSequence[] elements, CharSequence[] uniformElements) {
        this.elements = elements;
        this.uniformElements = uniformElements;
    }

    public boolean isEmpty() {
        return this.elements.length == 0;
    }

    public boolean isLastElementIndexed() {
        int size = this.getNumberOfElements();
        return size > 0 && ConfigurationPropertyName.isIndexed(this.elements[size - 1]);
    }

    boolean isIndexed(int elementIndex) {
        return ConfigurationPropertyName.isIndexed(this.elements[elementIndex]);
    }

    public boolean IsNumericIndex(int elementIndex) {
        return this.isIndexed(elementIndex) && this.isNumeric(this.getElement(elementIndex, Form.ORIGINAL));
    }

    private boolean isNumeric(CharSequence element) {
        for (int i = 0; i < element.length(); ++i) {
            if (Character.isDigit(element.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public String getLastElement(Form form) {
        int size = this.getNumberOfElements();
        return size == 0 ? EMPTY_STRING : this.getElement(size - 1, form);
    }

    public String getElement(int elementIndex, Form form) {
        if (form == Form.ORIGINAL) {
            CharSequence result = this.elements[elementIndex];
            if (ConfigurationPropertyName.isIndexed(result)) {
                result = result.subSequence(1, result.length() - 1);
            }
            return result.toString();
        }
        CharSequence result = this.uniformElements[elementIndex];
        if (result == null) {
            result = this.elements[elementIndex];
            result = ConfigurationPropertyName.isIndexed(result) ? result.subSequence(1, result.length() - 1) : ConfigurationPropertyName.cleanupCharSequence(result, (c, i) -> c == '-' || c == '_', CharProcessor.LOWERCASE);
            this.uniformElements[elementIndex] = result;
        }
        return result.toString();
    }

    public int getNumberOfElements() {
        return this.elements.length;
    }

    public ConfigurationPropertyName append(String elementValue) {
        if (elementValue == null) {
            return this;
        }
        ConfigurationPropertyName.process(elementValue, '.', (value, start, end, indexed) -> Assert.isTrue((start == 0 ? 1 : 0) != 0, () -> "Element value '" + elementValue + "' must be a single item"));
        Assert.isTrue((ConfigurationPropertyName.isIndexed(elementValue) || ElementValidator.isValidElement(elementValue) ? 1 : 0) != 0, () -> "Element value '" + elementValue + "' is not valid");
        int length = this.elements.length;
        CharSequence[] elements = new CharSequence[length + 1];
        System.arraycopy(this.elements, 0, elements, 0, length);
        elements[length] = elementValue;
        CharSequence[] uniformElements = new CharSequence[length + 1];
        System.arraycopy(this.uniformElements, 0, uniformElements, 0, length);
        return new ConfigurationPropertyName(elements, uniformElements);
    }

    public ConfigurationPropertyName chop(int size) {
        if (size >= this.getNumberOfElements()) {
            return this;
        }
        CharSequence[] elements = new CharSequence[size];
        System.arraycopy(this.elements, 0, elements, 0, size);
        CharSequence[] uniformElements = new CharSequence[size];
        System.arraycopy(this.uniformElements, 0, uniformElements, 0, size);
        return new ConfigurationPropertyName(elements, uniformElements);
    }

    public boolean isParentOf(ConfigurationPropertyName name) {
        Assert.notNull((Object)name, (String)"Name must not be null");
        if (this.getNumberOfElements() != name.getNumberOfElements() - 1) {
            return false;
        }
        return this.isAncestorOf(name);
    }

    public boolean isAncestorOf(ConfigurationPropertyName name) {
        Assert.notNull((Object)name, (String)"Name must not be null");
        if (this.getNumberOfElements() >= name.getNumberOfElements()) {
            return false;
        }
        for (int i = 0; i < this.elements.length; ++i) {
            if (this.elementEquals(this.elements[i], name.elements[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(ConfigurationPropertyName other) {
        return this.compare(this, other);
    }

    private int compare(ConfigurationPropertyName n1, ConfigurationPropertyName n2) {
        int l1 = n1.getNumberOfElements();
        int l2 = n2.getNumberOfElements();
        int i1 = 0;
        int i2 = 0;
        while (i1 < l1 || i2 < l2) {
            boolean indexed2;
            String e2;
            boolean indexed1;
            String e1 = i1 < l1 ? n1.getElement(i1++, Form.UNIFORM) : null;
            int result = this.compare(e1, indexed1 = i1 < l1 ? n1.isIndexed(i2) : false, e2 = i2 < l2 ? n2.getElement(i2++, Form.UNIFORM) : null, indexed2 = i2 < l2 ? n2.isIndexed(i2) : false);
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    private int compare(String e1, boolean indexed1, String e2, boolean indexed2) {
        if (e1 == null) {
            return -1;
        }
        if (e2 == null) {
            return 1;
        }
        int result = Boolean.compare(indexed2, indexed1);
        if (result != 0) {
            return result;
        }
        if (indexed1 && indexed2) {
            try {
                long v1 = Long.parseLong(e1.toString());
                long v2 = Long.parseLong(e2.toString());
                return Long.compare(v1, v2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return e1.compareTo(e2);
    }

    public String toString() {
        if (this.string == null) {
            this.string = this.toString(this.elements);
        }
        return this.string;
    }

    private String toString(CharSequence[] elements) {
        StringBuilder result = new StringBuilder();
        for (CharSequence element : elements) {
            boolean indexed = ConfigurationPropertyName.isIndexed(element);
            if (result.length() > 0 && !indexed) {
                result.append(".");
            }
            if (indexed) {
                result.append(element);
                continue;
            }
            for (int i = 0; i < element.length(); ++i) {
                char ch = Character.toLowerCase(element.charAt(i));
                result.append(ch == '_' ? EMPTY_STRING : Character.valueOf(ch));
            }
        }
        return result.toString();
    }

    public int hashCode() {
        if (this.elementHashCodes == null) {
            this.elementHashCodes = this.getElementHashCodes();
        }
        return ObjectUtils.nullSafeHashCode((int[])this.elementHashCodes);
    }

    private int[] getElementHashCodes() {
        int[] hashCodes = new int[this.elements.length];
        for (int i = 0; i < this.elements.length; ++i) {
            hashCodes[i] = this.getElementHashCode(this.elements[i]);
        }
        return hashCodes;
    }

    private int getElementHashCode(CharSequence element) {
        int hash = 0;
        boolean indexed = ConfigurationPropertyName.isIndexed(element);
        int offset = indexed ? 1 : 0;
        for (int i = 0 + offset; i < element.length() - offset; ++i) {
            char ch = indexed ? element.charAt(i) : Character.toLowerCase(element.charAt(i));
            hash = ch == '-' || ch == '_' ? hash : 31 * hash + Character.hashCode(ch);
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        ConfigurationPropertyName other = (ConfigurationPropertyName)obj;
        if (this.getNumberOfElements() != other.getNumberOfElements()) {
            return false;
        }
        for (int i = 0; i < this.elements.length; ++i) {
            if (this.elementEquals(this.elements[i], other.elements[i])) continue;
            return false;
        }
        return true;
    }

    private boolean elementEquals(CharSequence e1, CharSequence e2) {
        int l1 = e1.length();
        int l2 = e2.length();
        boolean indexed1 = ConfigurationPropertyName.isIndexed(e1);
        int offset1 = indexed1 ? 1 : 0;
        boolean indexed2 = ConfigurationPropertyName.isIndexed(e2);
        int offset2 = indexed2 ? 1 : 0;
        int i1 = offset1;
        int i2 = offset2;
        while (i1 < l1 - offset1) {
            char ch2;
            if (i2 >= l2 - offset2) {
                return false;
            }
            char ch1 = indexed1 ? e1.charAt(i1) : Character.toLowerCase(e1.charAt(i1));
            char c = ch2 = indexed2 ? e2.charAt(i2) : Character.toLowerCase(e2.charAt(i2));
            if (ch1 == '-' || ch1 == '_') {
                ++i1;
                continue;
            }
            if (ch2 == '-' || ch2 == '_') {
                ++i2;
                continue;
            }
            if (ch1 != ch2) {
                return false;
            }
            ++i1;
            ++i2;
        }
        while (i2 < l2 - offset2) {
            char ch;
            if ((ch = e2.charAt(i2++)) == '-' || ch == '_') continue;
            return false;
        }
        return true;
    }

    private static boolean isIndexed(CharSequence element) {
        int length = element.length();
        return length > 2 && element.charAt(0) == '[' && element.charAt(length - 1) == ']';
    }

    public static boolean isValid(CharSequence name) {
        if (name == null) {
            return false;
        }
        if (name.equals(EMPTY_STRING)) {
            return true;
        }
        if (name.charAt(0) == '.' || name.charAt(name.length() - 1) == '.') {
            return false;
        }
        ElementValidator validator = new ElementValidator();
        ConfigurationPropertyName.process(name, '.', validator);
        return validator.isValid();
    }

    public static ConfigurationPropertyName of(CharSequence name) {
        Assert.notNull((Object)name, (String)"Name must not be null");
        if (name.length() >= 1 && (name.charAt(0) == '.' || name.charAt(name.length() - 1) == '.')) {
            throw new IllegalArgumentException("Configuration property name '" + name + "' is not valid");
        }
        if (name.length() == 0) {
            return EMPTY;
        }
        ArrayList elements = new ArrayList(10);
        ConfigurationPropertyName.process(name, '.', (elementValue, start, end, indexed) -> {
            if (elementValue.length() > 0) {
                Assert.isTrue((indexed || ElementValidator.isValidElement(elementValue) ? 1 : 0) != 0, () -> "Configuration property name '" + name + "' is not valid");
                elements.add(elementValue);
            }
        });
        return new ConfigurationPropertyName(elements.toArray(new CharSequence[elements.size()]));
    }

    static ConfigurationPropertyName adapt(CharSequence name, char separator) {
        return ConfigurationPropertyName.adapt(name, separator, Function.identity());
    }

    static ConfigurationPropertyName adapt(CharSequence name, char separator, Function<CharSequence, CharSequence> elementValueProcessor) {
        Assert.notNull((Object)name, (String)"Name must not be null");
        Assert.notNull(elementValueProcessor, (String)"ElementValueProcessor must not be null");
        if (name.length() == 0) {
            return EMPTY;
        }
        ArrayList elements = new ArrayList(10);
        ConfigurationPropertyName.process(name, separator, (elementValue, start, end, indexed) -> {
            if (!ConfigurationPropertyName.isIndexed(elementValue = (CharSequence)elementValueProcessor.apply(elementValue))) {
                elementValue = ConfigurationPropertyName.cleanupCharSequence(elementValue, (ch, index) -> ch != '_' && !ElementValidator.isValidChar(Character.toLowerCase(ch), index), CharProcessor.NONE);
            }
            if (elementValue.length() > 0) {
                elements.add(elementValue);
            }
        });
        return new ConfigurationPropertyName(elements.toArray(new CharSequence[elements.size()]));
    }

    private static void process(CharSequence name, char separator, ElementProcessor processor) {
        int start = 0;
        boolean indexed = false;
        int length = name.length();
        int openBracketCount = 0;
        for (int i = 0; i < length; ++i) {
            char ch = name.charAt(i);
            if (ch == ']') {
                if (--openBracketCount != 0) continue;
                ConfigurationPropertyName.processElement(processor, name, start, i + 1, indexed);
                start = i + 1;
                indexed = false;
                continue;
            }
            if (ch == '[') {
                ++openBracketCount;
                if (indexed) continue;
                ConfigurationPropertyName.processElement(processor, name, start, i, indexed);
                start = i;
                indexed = true;
                continue;
            }
            if (indexed || ch != separator) continue;
            ConfigurationPropertyName.processElement(processor, name, start, i, indexed);
            start = i + 1;
        }
        ConfigurationPropertyName.processElement(processor, name, start, length, false);
    }

    private static void processElement(ElementProcessor processor, CharSequence name, int start, int end, boolean indexed) {
        if (end - start >= 1) {
            processor.process(name.subSequence(start, end), start, end, indexed);
        }
    }

    private static CharSequence cleanupCharSequence(CharSequence name, CharFilter filter, CharProcessor processor) {
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            char processed = processor.process(ch, i);
            if (!filter.isExcluded(processed, i) && processed == ch) continue;
            StringBuilder result = new StringBuilder(name.length());
            result.append(name.subSequence(0, i));
            for (int j = i; j < name.length(); ++j) {
                processed = processor.process(name.charAt(j), j);
                if (filter.isExcluded(processed, j)) continue;
                result.append(processed);
            }
            return result;
        }
        return name;
    }

    private static class ElementValidator
    implements ElementProcessor {
        private boolean valid = true;

        private ElementValidator() {
        }

        @Override
        public void process(CharSequence elementValue, int start, int end, boolean indexed) {
            if (this.valid && !indexed) {
                this.valid = ElementValidator.isValidElement(elementValue);
            }
        }

        public boolean isValid() {
            return this.valid;
        }

        public static boolean isValidElement(CharSequence elementValue) {
            for (int i = 0; i < elementValue.length(); ++i) {
                if (ElementValidator.isValidChar(elementValue.charAt(i), i)) continue;
                return false;
            }
            return true;
        }

        public static boolean isValidChar(char ch, int index) {
            boolean isNumeric;
            boolean isAlpha = ch >= 'a' && ch <= 'z';
            boolean bl = isNumeric = ch >= '0' && ch <= '9';
            if (index == 0) {
                return isAlpha;
            }
            return isAlpha || isNumeric || ch == '-';
        }
    }

    private static interface CharProcessor {
        public static final CharProcessor NONE = (c, i) -> c;
        public static final CharProcessor LOWERCASE = (c, i) -> Character.toLowerCase(c);

        public char process(char var1, int var2);
    }

    private static interface CharFilter {
        public boolean isExcluded(char var1, int var2);
    }

    @FunctionalInterface
    private static interface ElementProcessor {
        public void process(CharSequence var1, int var2, int var3, boolean var4);
    }

    public static enum Form {
        ORIGINAL,
        UNIFORM;

    }
}

