/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.context.properties.ConfigurationBeanFactoryMetaData;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinder;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinderBuilder;
import org.springframework.boot.context.properties.ConfigurationPropertiesBindingException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.PriorityOrdered;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.validation.Validator;

public class ConfigurationPropertiesBindingPostProcessor
implements BeanPostProcessor,
BeanFactoryAware,
EnvironmentAware,
ApplicationContextAware,
InitializingBean,
DisposableBean,
ApplicationListener<ContextRefreshedEvent>,
PriorityOrdered {
    private static final Log logger = LogFactory.getLog(ConfigurationPropertiesBindingPostProcessor.class);
    private ConfigurationBeanFactoryMetaData beans = new ConfigurationBeanFactoryMetaData();
    private Iterable<PropertySource<?>> propertySources;
    private Validator validator;
    private ConversionService conversionService;
    private BeanFactory beanFactory;
    private Environment environment = new StandardEnvironment();
    private ApplicationContext applicationContext;
    private int order = -2147483647;
    private ConfigurationPropertiesBinder configurationPropertiesBinder;

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void setPropertySources(Iterable<PropertySource<?>> propertySources) {
        this.propertySources = propertySources;
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public void setBeanMetaDataStore(ConfigurationBeanFactoryMetaData beans) {
        this.beans = beans;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.propertySources == null) {
            this.propertySources = this.deducePropertySources();
        }
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        this.freeBinder();
    }

    public void destroy() {
        this.freeBinder();
    }

    private void freeBinder() {
        if (this.configurationPropertiesBinder != null) {
            this.configurationPropertiesBinder.destroy();
        }
        this.configurationPropertiesBinder = null;
    }

    private PropertySources deducePropertySources() {
        PropertySourcesPlaceholderConfigurer configurer = this.getSinglePropertySourcesPlaceholderConfigurer();
        if (configurer != null) {
            return configurer.getAppliedPropertySources();
        }
        if (this.environment instanceof ConfigurableEnvironment) {
            return ((ConfigurableEnvironment)this.environment).getPropertySources();
        }
        throw new IllegalStateException("Unable to obtain PropertySources from PropertySourcesPlaceholderConfigurer or Environment");
    }

    private PropertySourcesPlaceholderConfigurer getSinglePropertySourcesPlaceholderConfigurer() {
        if (this.beanFactory instanceof ListableBeanFactory) {
            ListableBeanFactory listableBeanFactory = (ListableBeanFactory)this.beanFactory;
            Map beans = listableBeanFactory.getBeansOfType(PropertySourcesPlaceholderConfigurer.class, false, false);
            if (beans.size() == 1) {
                return (PropertySourcesPlaceholderConfigurer)beans.values().iterator().next();
            }
            if (beans.size() > 1 && logger.isWarnEnabled()) {
                logger.warn((Object)("Multiple PropertySourcesPlaceholderConfigurer beans registered " + beans.keySet() + ", falling back to Environment"));
            }
        }
        return null;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        ConfigurationProperties annotation = this.getAnnotation(bean, beanName);
        if (annotation != null) {
            try {
                this.getBinder().bind(bean, annotation);
            }
            catch (ConfigurationPropertiesBindingException ex) {
                throw new BeanCreationException(beanName, ex.getMessage(), ex.getCause());
            }
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    private ConfigurationProperties getAnnotation(Object bean, String beanName) {
        ConfigurationProperties annotation = this.beans.findFactoryAnnotation(beanName, ConfigurationProperties.class);
        if (annotation == null) {
            annotation = (ConfigurationProperties)AnnotationUtils.findAnnotation(bean.getClass(), ConfigurationProperties.class);
        }
        return annotation;
    }

    private ConfigurationPropertiesBinder getBinder() {
        if (this.configurationPropertiesBinder == null) {
            this.configurationPropertiesBinder = new ConfigurationPropertiesBinderBuilder(this.applicationContext).withConversionService(this.conversionService).withValidator(this.validator).withPropertySources(this.propertySources).build();
        }
        return this.configurationPropertiesBinder;
    }
}

