/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.diagnostics.analyzer;

import org.springframework.boot.context.properties.bind.BindException;
import org.springframework.boot.context.properties.bind.UnboundConfigurationPropertiesException;
import org.springframework.boot.context.properties.bind.validation.BindValidationException;
import org.springframework.boot.context.properties.source.ConfigurationProperty;
import org.springframework.boot.diagnostics.AbstractFailureAnalyzer;
import org.springframework.boot.diagnostics.FailureAnalysis;
import org.springframework.util.StringUtils;

class BindFailureAnalyzer
extends AbstractFailureAnalyzer<BindException> {
    BindFailureAnalyzer() {
    }

    @Override
    protected FailureAnalysis analyze(Throwable rootFailure, BindException cause) {
        Throwable rootCause = cause.getCause();
        if (rootCause instanceof BindValidationException || rootCause instanceof UnboundConfigurationPropertiesException) {
            return null;
        }
        return this.analyzeGenericBindException(cause);
    }

    private FailureAnalysis analyzeGenericBindException(BindException cause) {
        StringBuilder description = new StringBuilder(String.format("Binding to target %s failed:%n", cause.getTarget()));
        ConfigurationProperty property = cause.getProperty();
        this.buildDescription(description, property);
        description.append(String.format("%n    Reason: %s", this.getMessage(cause)));
        return this.getFailureAnalysis(description, cause);
    }

    private void buildDescription(StringBuilder description, ConfigurationProperty property) {
        if (property != null) {
            description.append(String.format("%n    Property: %s", property.getName()));
            description.append(String.format("%n    Value: %s", property.getValue()));
            description.append(String.format("%n    Origin: %s", property.getOrigin()));
        }
    }

    private String getMessage(BindException cause) {
        if (cause.getCause() != null && StringUtils.hasText((String)cause.getCause().getMessage())) {
            return cause.getCause().getMessage();
        }
        return cause.getMessage();
    }

    private FailureAnalysis getFailureAnalysis(Object description, BindException cause) {
        return new FailureAnalysis(description.toString(), "Update your application's configuration", cause);
    }
}

