/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.config.FilteredPropertySource;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.bind.PropertySourcesPlaceholdersResolver;
import org.springframework.boot.context.properties.source.ConfigurationPropertySources;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.env.PropertySourceLoader;
import org.springframework.boot.env.RandomValuePropertySource;
import org.springframework.boot.logging.DeferredLog;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.SmartApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.Profiles;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;

public class ConfigFileApplicationListener
implements EnvironmentPostProcessor,
SmartApplicationListener,
Ordered {
    private static final String DEFAULT_PROPERTIES = "defaultProperties";
    private static final String DEFAULT_SEARCH_LOCATIONS = "classpath:/,classpath:/config/,file:./,file:./config/";
    private static final String DEFAULT_NAMES = "application";
    private static final Set<String> NO_SEARCH_NAMES = Collections.singleton(null);
    private static final Bindable<String[]> STRING_ARRAY = Bindable.of(String[].class);
    private static final Bindable<List<String>> STRING_LIST = Bindable.listOf(String.class);
    private static final Set<String> LOAD_FILTERED_PROPERTY;
    public static final String ACTIVE_PROFILES_PROPERTY = "spring.profiles.active";
    public static final String INCLUDE_PROFILES_PROPERTY = "spring.profiles.include";
    public static final String CONFIG_NAME_PROPERTY = "spring.config.name";
    public static final String CONFIG_LOCATION_PROPERTY = "spring.config.location";
    public static final String CONFIG_ADDITIONAL_LOCATION_PROPERTY = "spring.config.additional-location";
    public static final int DEFAULT_ORDER = -2147483638;
    private final DeferredLog logger = new DeferredLog();
    private String searchLocations;
    private String names;
    private int order = -2147483638;

    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        return ApplicationEnvironmentPreparedEvent.class.isAssignableFrom(eventType) || ApplicationPreparedEvent.class.isAssignableFrom(eventType);
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ApplicationEnvironmentPreparedEvent) {
            this.onApplicationEnvironmentPreparedEvent((ApplicationEnvironmentPreparedEvent)event);
        }
        if (event instanceof ApplicationPreparedEvent) {
            this.onApplicationPreparedEvent(event);
        }
    }

    private void onApplicationEnvironmentPreparedEvent(ApplicationEnvironmentPreparedEvent event) {
        List<EnvironmentPostProcessor> postProcessors = this.loadPostProcessors();
        postProcessors.add(this);
        AnnotationAwareOrderComparator.sort(postProcessors);
        for (EnvironmentPostProcessor postProcessor : postProcessors) {
            postProcessor.postProcessEnvironment(event.getEnvironment(), event.getSpringApplication());
        }
    }

    List<EnvironmentPostProcessor> loadPostProcessors() {
        return SpringFactoriesLoader.loadFactories(EnvironmentPostProcessor.class, (ClassLoader)this.getClass().getClassLoader());
    }

    @Override
    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        this.addPropertySources(environment, application.getResourceLoader());
    }

    private void onApplicationPreparedEvent(ApplicationEvent event) {
        this.logger.switchTo(ConfigFileApplicationListener.class);
        this.addPostProcessors(((ApplicationPreparedEvent)event).getApplicationContext());
    }

    protected void addPropertySources(ConfigurableEnvironment environment, ResourceLoader resourceLoader) {
        RandomValuePropertySource.addToEnvironment(environment);
        new Loader(environment, resourceLoader).load();
    }

    protected void addPostProcessors(ConfigurableApplicationContext context) {
        context.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)new PropertySourceOrderingPostProcessor(context));
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void setSearchLocations(String locations) {
        Assert.hasLength((String)locations, (String)"Locations must not be empty");
        this.searchLocations = locations;
    }

    public void setSearchNames(String names) {
        Assert.hasLength((String)names, (String)"Names must not be empty");
        this.names = names;
    }

    static {
        HashSet<String> filteredProperties = new HashSet<String>();
        filteredProperties.add(ACTIVE_PROFILES_PROPERTY);
        filteredProperties.add(INCLUDE_PROFILES_PROPERTY);
        LOAD_FILTERED_PROPERTY = Collections.unmodifiableSet(filteredProperties);
    }

    @FunctionalInterface
    private static interface DocumentConsumer {
        public void accept(Profile var1, Document var2);
    }

    @FunctionalInterface
    private static interface DocumentFilter {
        public boolean match(Document var1);
    }

    @FunctionalInterface
    private static interface DocumentFilterFactory {
        public DocumentFilter getDocumentFilter(Profile var1);
    }

    private static class Document {
        private final PropertySource<?> propertySource;
        private String[] profiles;
        private final Set<Profile> activeProfiles;
        private final Set<Profile> includeProfiles;

        Document(PropertySource<?> propertySource, String[] profiles, Set<Profile> activeProfiles, Set<Profile> includeProfiles) {
            this.propertySource = propertySource;
            this.profiles = profiles;
            this.activeProfiles = activeProfiles;
            this.includeProfiles = includeProfiles;
        }

        public PropertySource<?> getPropertySource() {
            return this.propertySource;
        }

        public String[] getProfiles() {
            return this.profiles;
        }

        public Set<Profile> getActiveProfiles() {
            return this.activeProfiles;
        }

        public Set<Profile> getIncludeProfiles() {
            return this.includeProfiles;
        }

        public String toString() {
            return this.propertySource.toString();
        }
    }

    private static class DocumentsCacheKey {
        private final PropertySourceLoader loader;
        private final Resource resource;

        DocumentsCacheKey(PropertySourceLoader loader, Resource resource) {
            this.loader = loader;
            this.resource = resource;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            DocumentsCacheKey other = (DocumentsCacheKey)obj;
            return this.loader.equals(other.loader) && this.resource.equals(other.resource);
        }

        public int hashCode() {
            return this.loader.hashCode() * 31 + this.resource.hashCode();
        }
    }

    private static class Profile {
        private final String name;
        private final boolean defaultProfile;

        Profile(String name) {
            this(name, false);
        }

        Profile(String name, boolean defaultProfile) {
            Assert.notNull((Object)name, (String)"Name must not be null");
            this.name = name;
            this.defaultProfile = defaultProfile;
        }

        public String getName() {
            return this.name;
        }

        public boolean isDefaultProfile() {
            return this.defaultProfile;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            return ((Profile)obj).name.equals(this.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return this.name;
        }
    }

    private class Loader {
        private final Log logger;
        private final ConfigurableEnvironment environment;
        private final PropertySourcesPlaceholdersResolver placeholdersResolver;
        private final ResourceLoader resourceLoader;
        private final List<PropertySourceLoader> propertySourceLoaders;
        private Deque<Profile> profiles;
        private List<Profile> processedProfiles;
        private boolean activatedProfiles;
        private Map<Profile, MutablePropertySources> loaded;
        private Map<DocumentsCacheKey, List<Document>> loadDocumentsCache;

        Loader(ConfigurableEnvironment environment, ResourceLoader resourceLoader) {
            this.logger = ConfigFileApplicationListener.this.logger;
            this.loadDocumentsCache = new HashMap<DocumentsCacheKey, List<Document>>();
            this.environment = environment;
            this.placeholdersResolver = new PropertySourcesPlaceholdersResolver((Environment)this.environment);
            this.resourceLoader = resourceLoader != null ? resourceLoader : new DefaultResourceLoader();
            this.propertySourceLoaders = SpringFactoriesLoader.loadFactories(PropertySourceLoader.class, (ClassLoader)this.getClass().getClassLoader());
        }

        public void load() {
            FilteredPropertySource.apply(this.environment, ConfigFileApplicationListener.DEFAULT_PROPERTIES, LOAD_FILTERED_PROPERTY, defaultProperties -> {
                this.profiles = new LinkedList<Profile>();
                this.processedProfiles = new LinkedList<Profile>();
                this.activatedProfiles = false;
                this.loaded = new LinkedHashMap<Profile, MutablePropertySources>();
                this.initializeProfiles();
                while (!this.profiles.isEmpty()) {
                    Profile profile = this.profiles.poll();
                    if (this.isDefaultProfile(profile)) {
                        this.addProfileToEnvironment(profile.getName());
                    }
                    this.load(profile, this::getPositiveProfileFilter, this.addToLoaded(MutablePropertySources::addLast, false));
                    this.processedProfiles.add(profile);
                }
                this.load(null, this::getNegativeProfileFilter, this.addToLoaded(MutablePropertySources::addFirst, true));
                this.addLoadedPropertySources();
                this.applyActiveProfiles((PropertySource<?>)defaultProperties);
            });
        }

        private void initializeProfiles() {
            this.profiles.add(null);
            Set<Profile> activatedViaProperty = this.getProfilesFromProperty(ConfigFileApplicationListener.ACTIVE_PROFILES_PROPERTY);
            Set<Profile> includedViaProperty = this.getProfilesFromProperty(ConfigFileApplicationListener.INCLUDE_PROFILES_PROPERTY);
            List<Profile> otherActiveProfiles = this.getOtherActiveProfiles(activatedViaProperty, includedViaProperty);
            this.profiles.addAll(otherActiveProfiles);
            this.profiles.addAll(includedViaProperty);
            this.addActiveProfiles(activatedViaProperty);
            if (this.profiles.size() == 1) {
                for (String defaultProfileName : this.environment.getDefaultProfiles()) {
                    Profile defaultProfile = new Profile(defaultProfileName, true);
                    this.profiles.add(defaultProfile);
                }
            }
        }

        private Set<Profile> getProfilesFromProperty(String profilesProperty) {
            if (!this.environment.containsProperty(profilesProperty)) {
                return Collections.emptySet();
            }
            Binder binder = Binder.get((Environment)this.environment);
            Set<Profile> profiles = this.getProfiles(binder, profilesProperty);
            return new LinkedHashSet<Profile>(profiles);
        }

        private List<Profile> getOtherActiveProfiles(Set<Profile> activatedViaProperty, Set<Profile> includedViaProperty) {
            return Arrays.stream(this.environment.getActiveProfiles()).map(Profile::new).filter(profile -> !activatedViaProperty.contains(profile) && !includedViaProperty.contains(profile)).collect(Collectors.toList());
        }

        void addActiveProfiles(Set<Profile> profiles) {
            if (profiles.isEmpty()) {
                return;
            }
            if (this.activatedProfiles) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Profiles already activated, '" + profiles + "' will not be applied"));
                }
                return;
            }
            this.profiles.addAll(profiles);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Activated activeProfiles " + StringUtils.collectionToCommaDelimitedString(profiles)));
            }
            this.activatedProfiles = true;
            this.removeUnprocessedDefaultProfiles();
        }

        private void removeUnprocessedDefaultProfiles() {
            this.profiles.removeIf(profile -> profile != null && profile.isDefaultProfile());
        }

        private DocumentFilter getPositiveProfileFilter(Profile profile) {
            return document -> {
                if (profile == null) {
                    return ObjectUtils.isEmpty((Object[])document.getProfiles());
                }
                return ObjectUtils.containsElement((Object[])document.getProfiles(), (Object)profile.getName()) && this.environment.acceptsProfiles(Profiles.of((String[])document.getProfiles()));
            };
        }

        private DocumentFilter getNegativeProfileFilter(Profile profile) {
            return document -> profile == null && !ObjectUtils.isEmpty((Object[])document.getProfiles()) && this.environment.acceptsProfiles(Profiles.of((String[])document.getProfiles()));
        }

        private DocumentConsumer addToLoaded(BiConsumer<MutablePropertySources, PropertySource<?>> addMethod, boolean checkForExisting) {
            return (profile, document) -> {
                if (checkForExisting) {
                    for (MutablePropertySources merged : this.loaded.values()) {
                        if (!merged.contains(document.getPropertySource().getName())) continue;
                        return;
                    }
                }
                MutablePropertySources merged = this.loaded.computeIfAbsent(profile, k -> new MutablePropertySources());
                addMethod.accept(merged, document.getPropertySource());
            };
        }

        private void load(Profile profile, DocumentFilterFactory filterFactory, DocumentConsumer consumer) {
            this.getSearchLocations().forEach(location -> {
                boolean isFolder = location.endsWith("/");
                Set<String> names = isFolder ? this.getSearchNames() : NO_SEARCH_NAMES;
                names.forEach(name -> this.load((String)location, (String)name, profile, filterFactory, consumer));
            });
        }

        private void load(String location, String name, Profile profile, DocumentFilterFactory filterFactory, DocumentConsumer consumer) {
            if (!StringUtils.hasText((String)name)) {
                for (PropertySourceLoader loader : this.propertySourceLoaders) {
                    if (!this.canLoadFileExtension(loader, location)) continue;
                    this.load(loader, location, profile, filterFactory.getDocumentFilter(profile), consumer);
                    return;
                }
            }
            HashSet<String> processed = new HashSet<String>();
            for (PropertySourceLoader loader : this.propertySourceLoaders) {
                for (String fileExtension : loader.getFileExtensions()) {
                    if (!processed.add(fileExtension)) continue;
                    this.loadForFileExtension(loader, location + name, "." + fileExtension, profile, filterFactory, consumer);
                }
            }
        }

        private boolean canLoadFileExtension(PropertySourceLoader loader, String name) {
            return Arrays.stream(loader.getFileExtensions()).anyMatch(fileExtension -> StringUtils.endsWithIgnoreCase((String)name, (String)fileExtension));
        }

        private void loadForFileExtension(PropertySourceLoader loader, String prefix, String fileExtension, Profile profile, DocumentFilterFactory filterFactory, DocumentConsumer consumer) {
            DocumentFilter defaultFilter = filterFactory.getDocumentFilter(null);
            DocumentFilter profileFilter = filterFactory.getDocumentFilter(profile);
            if (profile != null) {
                String profileSpecificFile = prefix + "-" + profile + fileExtension;
                this.load(loader, profileSpecificFile, profile, defaultFilter, consumer);
                this.load(loader, profileSpecificFile, profile, profileFilter, consumer);
                for (Profile processedProfile : this.processedProfiles) {
                    if (processedProfile == null) continue;
                    String previouslyLoaded = prefix + "-" + processedProfile + fileExtension;
                    this.load(loader, previouslyLoaded, profile, profileFilter, consumer);
                }
            }
            this.load(loader, prefix + fileExtension, profile, profileFilter, consumer);
        }

        private void load(PropertySourceLoader loader, String location, Profile profile, DocumentFilter filter, DocumentConsumer consumer) {
            try {
                Resource resource = this.resourceLoader.getResource(location);
                if (resource == null || !resource.exists()) {
                    if (this.logger.isTraceEnabled()) {
                        StringBuilder description = this.getDescription("Skipped missing config ", location, resource, profile);
                        this.logger.trace((Object)description);
                    }
                    return;
                }
                if (!StringUtils.hasText((String)StringUtils.getFilenameExtension((String)resource.getFilename()))) {
                    if (this.logger.isTraceEnabled()) {
                        StringBuilder description = this.getDescription("Skipped empty config extension ", location, resource, profile);
                        this.logger.trace((Object)description);
                    }
                    return;
                }
                String name = "applicationConfig: [" + location + "]";
                List<Document> documents = this.loadDocuments(loader, name, resource);
                if (CollectionUtils.isEmpty(documents)) {
                    if (this.logger.isTraceEnabled()) {
                        StringBuilder description = this.getDescription("Skipped unloaded config ", location, resource, profile);
                        this.logger.trace((Object)description);
                    }
                    return;
                }
                ArrayList<Document> loaded = new ArrayList<Document>();
                for (Document document2 : documents) {
                    if (!filter.match(document2)) continue;
                    this.addActiveProfiles(document2.getActiveProfiles());
                    this.addIncludedProfiles(document2.getIncludeProfiles());
                    loaded.add(document2);
                }
                Collections.reverse(loaded);
                if (!loaded.isEmpty()) {
                    loaded.forEach(document -> consumer.accept(profile, (Document)document));
                    if (this.logger.isDebugEnabled()) {
                        StringBuilder description = this.getDescription("Loaded config file ", location, resource, profile);
                        this.logger.debug((Object)description);
                    }
                }
            }
            catch (Exception ex) {
                throw new IllegalStateException("Failed to load property source from location '" + location + "'", ex);
            }
        }

        private void addIncludedProfiles(Set<Profile> includeProfiles) {
            LinkedList<Profile> existingProfiles = new LinkedList<Profile>(this.profiles);
            this.profiles.clear();
            this.profiles.addAll(includeProfiles);
            this.profiles.removeAll(this.processedProfiles);
            this.profiles.addAll(existingProfiles);
        }

        private List<Document> loadDocuments(PropertySourceLoader loader, String name, Resource resource) throws IOException {
            DocumentsCacheKey cacheKey = new DocumentsCacheKey(loader, resource);
            List<Document> documents = this.loadDocumentsCache.get(cacheKey);
            if (documents == null) {
                List<PropertySource<?>> loaded = loader.load(name, resource);
                documents = this.asDocuments(loaded);
                this.loadDocumentsCache.put(cacheKey, documents);
            }
            return documents;
        }

        private List<Document> asDocuments(List<PropertySource<?>> loaded) {
            if (loaded == null) {
                return Collections.emptyList();
            }
            return loaded.stream().map(propertySource -> {
                Binder binder = new Binder(ConfigurationPropertySources.from(propertySource), this.placeholdersResolver);
                return new Document((PropertySource<?>)propertySource, binder.bind("spring.profiles", STRING_ARRAY).orElse(null), this.getProfiles(binder, ConfigFileApplicationListener.ACTIVE_PROFILES_PROPERTY), this.getProfiles(binder, ConfigFileApplicationListener.INCLUDE_PROFILES_PROPERTY));
            }).collect(Collectors.toList());
        }

        private StringBuilder getDescription(String prefix, String location, Resource resource, Profile profile) {
            StringBuilder result = new StringBuilder(prefix);
            try {
                if (resource != null) {
                    String uri = resource.getURI().toASCIIString();
                    result.append("'");
                    result.append(uri);
                    result.append("' (");
                    result.append(location);
                    result.append(")");
                }
            }
            catch (IOException ex) {
                result.append(location);
            }
            if (profile != null) {
                result.append(" for profile ");
                result.append(profile);
            }
            return result;
        }

        private Set<Profile> getProfiles(Binder binder, String name) {
            return binder.bind(name, STRING_ARRAY).map(this::asProfileSet).orElse(Collections.emptySet());
        }

        private Set<Profile> asProfileSet(String[] profileNames) {
            ArrayList<Profile> profiles = new ArrayList<Profile>();
            for (String profileName : profileNames) {
                profiles.add(new Profile(profileName));
            }
            return new LinkedHashSet<Profile>(profiles);
        }

        private void addProfileToEnvironment(String profile) {
            for (String activeProfile : this.environment.getActiveProfiles()) {
                if (!activeProfile.equals(profile)) continue;
                return;
            }
            this.environment.addActiveProfile(profile);
        }

        private Set<String> getSearchLocations() {
            if (this.environment.containsProperty(ConfigFileApplicationListener.CONFIG_LOCATION_PROPERTY)) {
                return this.getSearchLocations(ConfigFileApplicationListener.CONFIG_LOCATION_PROPERTY);
            }
            Set<String> locations = this.getSearchLocations(ConfigFileApplicationListener.CONFIG_ADDITIONAL_LOCATION_PROPERTY);
            locations.addAll(this.asResolvedSet(ConfigFileApplicationListener.this.searchLocations, ConfigFileApplicationListener.DEFAULT_SEARCH_LOCATIONS));
            return locations;
        }

        private Set<String> getSearchLocations(String propertyName) {
            LinkedHashSet<String> locations = new LinkedHashSet<String>();
            if (this.environment.containsProperty(propertyName)) {
                for (String path : this.asResolvedSet(this.environment.getProperty(propertyName), null)) {
                    if (!path.contains("$") && !ResourceUtils.isUrl((String)(path = StringUtils.cleanPath((String)path)))) {
                        path = "file:" + path;
                    }
                    locations.add(path);
                }
            }
            return locations;
        }

        private Set<String> getSearchNames() {
            if (this.environment.containsProperty(ConfigFileApplicationListener.CONFIG_NAME_PROPERTY)) {
                String property = this.environment.getProperty(ConfigFileApplicationListener.CONFIG_NAME_PROPERTY);
                return this.asResolvedSet(property, null);
            }
            return this.asResolvedSet(ConfigFileApplicationListener.this.names, ConfigFileApplicationListener.DEFAULT_NAMES);
        }

        private Set<String> asResolvedSet(String value, String fallback) {
            List<String> list = Arrays.asList(StringUtils.trimArrayElements((String[])StringUtils.commaDelimitedListToStringArray((String)(value != null ? this.environment.resolvePlaceholders(value) : fallback))));
            Collections.reverse(list);
            return new LinkedHashSet<String>(list);
        }

        private void addLoadedPropertySources() {
            MutablePropertySources destination = this.environment.getPropertySources();
            ArrayList<MutablePropertySources> loaded = new ArrayList<MutablePropertySources>(this.loaded.values());
            Collections.reverse(loaded);
            String lastAdded = null;
            HashSet<String> added = new HashSet<String>();
            for (MutablePropertySources sources : loaded) {
                for (PropertySource source : sources) {
                    if (!added.add(source.getName())) continue;
                    this.addLoadedPropertySource(destination, lastAdded, source);
                    lastAdded = source.getName();
                }
            }
        }

        private void addLoadedPropertySource(MutablePropertySources destination, String lastAdded, PropertySource<?> source) {
            if (lastAdded == null) {
                if (destination.contains(ConfigFileApplicationListener.DEFAULT_PROPERTIES)) {
                    destination.addBefore(ConfigFileApplicationListener.DEFAULT_PROPERTIES, source);
                } else {
                    destination.addLast(source);
                }
            } else {
                destination.addAfter(lastAdded, source);
            }
        }

        private void applyActiveProfiles(PropertySource<?> defaultProperties) {
            ArrayList<String> activeProfiles = new ArrayList<String>();
            if (defaultProperties != null) {
                Binder binder = new Binder(ConfigurationPropertySources.from(defaultProperties), new PropertySourcesPlaceholdersResolver((Environment)this.environment));
                activeProfiles.addAll(this.getDefaultProfiles(binder, ConfigFileApplicationListener.INCLUDE_PROFILES_PROPERTY));
                if (!this.activatedProfiles) {
                    activeProfiles.addAll(this.getDefaultProfiles(binder, ConfigFileApplicationListener.ACTIVE_PROFILES_PROPERTY));
                }
            }
            this.processedProfiles.stream().filter(this::isDefaultProfile).map(Profile::getName).forEach(activeProfiles::add);
            this.environment.setActiveProfiles(activeProfiles.toArray(new String[0]));
        }

        private boolean isDefaultProfile(Profile profile) {
            return profile != null && !profile.isDefaultProfile();
        }

        private List<String> getDefaultProfiles(Binder binder, String property) {
            return binder.bind(property, STRING_LIST).orElse(Collections.emptyList());
        }
    }

    private class PropertySourceOrderingPostProcessor
    implements BeanFactoryPostProcessor,
    Ordered {
        private ConfigurableApplicationContext context;

        PropertySourceOrderingPostProcessor(ConfigurableApplicationContext context) {
            this.context = context;
        }

        public int getOrder() {
            return Integer.MIN_VALUE;
        }

        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
            this.reorderSources(this.context.getEnvironment());
        }

        private void reorderSources(ConfigurableEnvironment environment) {
            PropertySource defaultProperties = environment.getPropertySources().remove(ConfigFileApplicationListener.DEFAULT_PROPERTIES);
            if (defaultProperties != null) {
                environment.getPropertySources().addLast(defaultProperties);
            }
        }
    }
}

