/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.reactor;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.util.ClassUtils;
import reactor.tools.agent.ReactorDebugAgent;

public class DebugAgentEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    private static final String REACTOR_DEBUGAGENT_CLASS = "reactor.tools.agent.ReactorDebugAgent";
    private static final String DEBUGAGENT_ENABLED_CONFIG_KEY = "spring.reactor.debug-agent.enabled";

    @Override
    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        Boolean agentEnabled;
        if (ClassUtils.isPresent((String)REACTOR_DEBUGAGENT_CLASS, null) && (agentEnabled = (Boolean)environment.getProperty(DEBUGAGENT_ENABLED_CONFIG_KEY, Boolean.class)) != Boolean.FALSE) {
            ReactorDebugAgent.init();
        }
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

