/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.build.aws.maven;

import java.util.HashSet;
import java.util.Set;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.events.TransferEvent;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.resource.Resource;
import org.springframework.build.aws.maven.TransferListenerSupport;

final class StandardTransferListenerSupport
implements TransferListenerSupport {
    private final Wagon wagon;
    private final Set<TransferListener> transferListeners = new HashSet<TransferListener>();

    StandardTransferListenerSupport(Wagon wagon) {
        this.wagon = wagon;
    }

    @Override
    public void addTransferListener(TransferListener transferListener) {
        this.transferListeners.add(transferListener);
    }

    @Override
    public void removeTransferListener(TransferListener transferListener) {
        this.transferListeners.remove(transferListener);
    }

    @Override
    public boolean hasTransferListener(TransferListener transferListener) {
        return this.transferListeners.contains(transferListener);
    }

    @Override
    public void fireTransferInitiated(Resource resource, int requestType) {
        TransferEvent event = new TransferEvent(this.wagon, resource, 0, requestType);
        for (TransferListener transferListener : this.transferListeners) {
            transferListener.transferInitiated(event);
        }
    }

    @Override
    public void fireTransferStarted(Resource resource, int requestType) {
        TransferEvent event = new TransferEvent(this.wagon, resource, 1, requestType);
        for (TransferListener transferListener : this.transferListeners) {
            transferListener.transferStarted(event);
        }
    }

    @Override
    public void fireTransferProgress(Resource resource, int requestType, byte[] buffer, int length) {
        TransferEvent event = new TransferEvent(this.wagon, resource, 3, requestType);
        for (TransferListener transferListener : this.transferListeners) {
            transferListener.transferProgress(event, buffer, length);
        }
    }

    @Override
    public void fireTransferCompleted(Resource resource, int requestType) {
        TransferEvent event = new TransferEvent(this.wagon, resource, 2, requestType);
        for (TransferListener transferListener : this.transferListeners) {
            transferListener.transferCompleted(event);
        }
    }

    @Override
    public void fireTransferError(Resource resource, int requestType, Exception exception) {
        TransferEvent event = new TransferEvent(this.wagon, resource, exception, requestType);
        for (TransferListener transferListener : this.transferListeners) {
            transferListener.transferError(event);
        }
    }
}

