/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.actuate.metrics;

import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.cloudwatch.AmazonCloudWatchAsync;
import com.amazonaws.services.cloudwatch.model.MetricDatum;
import com.amazonaws.services.cloudwatch.model.PutMetricDataRequest;
import com.amazonaws.services.cloudwatch.model.PutMetricDataResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cloud.aws.actuate.metrics.CloudWatchMetricSender;
import org.springframework.cloud.aws.actuate.metrics.CloudWatchMetricWriter;
import org.springframework.context.SmartLifecycle;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.util.Assert;

public class BufferingCloudWatchMetricSender
implements CloudWatchMetricSender,
InitializingBean,
DisposableBean,
SmartLifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(CloudWatchMetricWriter.class);
    private static final int MAX_METRIC_DATA_PER_REQUEST = 20;
    private static final int FLUSH_TIMEOUT = 1000;
    private final String namespace;
    private final int maxBuffer;
    private final long fixedDelayBetweenRuns;
    private final AmazonCloudWatchAsync amazonCloudWatchAsync;
    private final LinkedBlockingQueue<MetricDatum> metricDataBuffer;
    private ScheduledFuture<?> scheduledFuture;
    private ThreadPoolTaskScheduler taskScheduler;

    public BufferingCloudWatchMetricSender(String namespace, int maxBuffer, long fixedDelayBetweenRuns, AmazonCloudWatchAsync amazonCloudWatchAsync) {
        Assert.hasText((String)namespace);
        this.namespace = namespace.trim();
        this.maxBuffer = maxBuffer;
        this.fixedDelayBetweenRuns = fixedDelayBetweenRuns;
        this.amazonCloudWatchAsync = amazonCloudWatchAsync;
        this.metricDataBuffer = new LinkedBlockingQueue(this.maxBuffer);
    }

    @Override
    public void send(MetricDatum metricDatum) {
        try {
            this.metricDataBuffer.put(metricDatum);
        }
        catch (InterruptedException e) {
            LOGGER.error("Error adding metric to queue", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    public String getNamespace() {
        return this.namespace;
    }

    public int getMaxBuffer() {
        return this.maxBuffer;
    }

    public long getFixedDelayBetweenRuns() {
        return this.fixedDelayBetweenRuns;
    }

    public void afterPropertiesSet() throws Exception {
        ThreadPoolTaskScheduler taskScheduler = new ThreadPoolTaskScheduler();
        taskScheduler.setWaitForTasksToCompleteOnShutdown(true);
        taskScheduler.afterPropertiesSet();
        this.taskScheduler = taskScheduler;
    }

    public void destroy() throws Exception {
        this.taskScheduler.destroy();
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    public void start() {
        this.scheduledFuture = this.taskScheduler.scheduleWithFixedDelay((Runnable)new CloudWatchMetricSenderRunnable(), this.fixedDelayBetweenRuns);
    }

    public void stop() {
        if (!this.scheduledFuture.isCancelled()) {
            this.scheduledFuture.cancel(false);
        }
        this.flushMetrics();
    }

    private void flushMetrics() {
        Future future = this.taskScheduler.submit((Runnable)new CloudWatchMetricSenderRunnable());
        try {
            future.get(1000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            LOGGER.error("Error flushing metrics", (Throwable)e);
        }
    }

    public boolean isRunning() {
        return this.scheduledFuture != null && !this.scheduledFuture.isCancelled() && !this.scheduledFuture.isDone();
    }

    public int getPhase() {
        return Integer.MAX_VALUE;
    }

    private class CloudWatchMetricSenderRunnable
    implements Runnable {
        private CloudWatchMetricSenderRunnable() {
        }

        @Override
        public void run() {
            try {
                while (!BufferingCloudWatchMetricSender.this.metricDataBuffer.isEmpty()) {
                    Collection<MetricDatum> metricData = this.collectNextMetricData();
                    if (metricData.isEmpty()) continue;
                    this.sendToCloudWatch(metricData);
                }
            }
            catch (Exception e) {
                LOGGER.error("Error executing metric collection run.", (Throwable)e);
            }
        }

        private Collection<MetricDatum> collectNextMetricData() {
            ArrayList<MetricDatum> metricData = new ArrayList<MetricDatum>(20);
            BufferingCloudWatchMetricSender.this.metricDataBuffer.drainTo(metricData, 20);
            return metricData;
        }

        private void sendToCloudWatch(Collection<MetricDatum> metricData) {
            PutMetricDataRequest putMetricDataRequest = new PutMetricDataRequest().withNamespace(BufferingCloudWatchMetricSender.this.namespace).withMetricData(metricData);
            BufferingCloudWatchMetricSender.this.amazonCloudWatchAsync.putMetricDataAsync(putMetricDataRequest, (AsyncHandler)new AsyncHandler<PutMetricDataRequest, PutMetricDataResult>(){

                public void onError(Exception exception) {
                    LOGGER.error("Error sending metric data.", (Throwable)exception);
                }

                public void onSuccess(PutMetricDataRequest request, PutMetricDataResult result) {
                    LOGGER.debug("Published metric with namespace:{}", (Object)request.getNamespace());
                }
            });
        }
    }
}

