/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.mail.simplemail;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.simpleemail.AmazonSimpleEmailService;
import com.amazonaws.services.simpleemail.model.Body;
import com.amazonaws.services.simpleemail.model.Content;
import com.amazonaws.services.simpleemail.model.Destination;
import com.amazonaws.services.simpleemail.model.Message;
import com.amazonaws.services.simpleemail.model.SendEmailRequest;
import com.amazonaws.services.simpleemail.model.SendEmailResult;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.mail.MailException;
import org.springframework.mail.MailSendException;
import org.springframework.mail.MailSender;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.util.StringUtils;

public class SimpleEmailServiceMailSender
implements MailSender,
DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleEmailServiceMailSender.class);
    private final AmazonSimpleEmailService emailService;

    public SimpleEmailServiceMailSender(AmazonSimpleEmailService amazonSimpleEmailService) {
        this.emailService = amazonSimpleEmailService;
    }

    public void send(SimpleMailMessage simpleMailMessage) throws MailException {
        this.send(new SimpleMailMessage[]{simpleMailMessage});
    }

    public void send(SimpleMailMessage ... simpleMailMessages) throws MailException {
        HashMap<SimpleMailMessage, AmazonClientException> failedMessages = new HashMap<SimpleMailMessage, AmazonClientException>();
        SimpleMailMessage[] simpleMailMessageArray = simpleMailMessages;
        int n = simpleMailMessages.length;
        int n2 = 0;
        while (n2 < n) {
            SimpleMailMessage simpleMessage = simpleMailMessageArray[n2];
            try {
                SendEmailResult sendEmailResult = this.getEmailService().sendEmail(this.prepareMessage(simpleMessage));
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Message with id: {0} successfully send", (Object)sendEmailResult.getMessageId());
                }
            }
            catch (AmazonClientException e) {
                failedMessages.put(simpleMessage, e);
            }
            ++n2;
        }
        if (!failedMessages.isEmpty()) {
            throw new MailSendException(failedMessages);
        }
    }

    public final void destroy() throws Exception {
        this.getEmailService().shutdown();
    }

    protected AmazonSimpleEmailService getEmailService() {
        return this.emailService;
    }

    private SendEmailRequest prepareMessage(SimpleMailMessage simpleMailMessage) {
        Destination destination = new Destination();
        destination.withToAddresses(simpleMailMessage.getTo());
        if (simpleMailMessage.getCc() != null) {
            destination.withCcAddresses(simpleMailMessage.getCc());
        }
        if (simpleMailMessage.getBcc() != null) {
            destination.withBccAddresses(simpleMailMessage.getBcc());
        }
        Content subject = new Content(simpleMailMessage.getSubject());
        Body body = new Body(new Content(simpleMailMessage.getText()));
        SendEmailRequest emailRequest = new SendEmailRequest(simpleMailMessage.getFrom(), destination, new Message(subject, body));
        if (StringUtils.hasText((String)simpleMailMessage.getReplyTo())) {
            emailRequest.withReplyToAddresses(new String[]{simpleMailMessage.getReplyTo()});
        }
        return emailRequest;
    }
}

