/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.jdbc.datasource.support;

import org.springframework.util.Assert;

public enum DatabaseType {
    MYSQL,
    ORACLE,
    SQLSERVER,
    POSTGRES,
    MARIA,
    AURORA;


    public static DatabaseType fromEngine(String engineName) {
        Assert.notNull((Object)engineName, (String)"Engine must not be null");
        for (DatabaseType databaseType : DatabaseType.values()) {
            if (!engineName.toUpperCase().startsWith(databaseType.toString())) continue;
            return databaseType;
        }
        throw new IllegalStateException("No database type found for engine:'" + engineName + "'");
    }
}

