/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bus;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.Endpoint;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.bootstrap.config.RefreshEndpoint;
import org.springframework.cloud.bus.ConditionalOnBusEnabled;
import org.springframework.cloud.bus.ServiceMatcher;
import org.springframework.cloud.bus.endpoint.BusEndpoint;
import org.springframework.cloud.bus.endpoint.EnvironmentBusEndpoint;
import org.springframework.cloud.bus.endpoint.RefreshBusEndpoint;
import org.springframework.cloud.bus.event.EnvironmentChangeListener;
import org.springframework.cloud.bus.event.RefreshListener;
import org.springframework.cloud.bus.event.RemoteApplicationEvent;
import org.springframework.cloud.context.environment.EnvironmentManager;
import org.springframework.cloud.context.scope.refresh.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.integration.channel.interceptor.WireTap;
import org.springframework.integration.config.GlobalChannelInterceptor;
import org.springframework.integration.core.GenericSelector;
import org.springframework.integration.dsl.IntegrationFlow;
import org.springframework.integration.dsl.IntegrationFlowBuilder;
import org.springframework.integration.dsl.IntegrationFlows;
import org.springframework.integration.dsl.channel.MessageChannels;
import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.integration.event.inbound.ApplicationEventListeningMessageProducer;
import org.springframework.integration.event.outbound.ApplicationEventPublishingMessageHandler;
import org.springframework.integration.handler.LoggingHandler;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;

@Configuration
@ConditionalOnBusEnabled
public class BusAutoConfiguration {
    @Autowired
    private ConfigurableApplicationContext context;

    @Bean
    public SubscribableChannel cloudBusOutboundChannel() {
        return new DirectChannel();
    }

    @Bean
    public GenericSelector<?> outboundFilter() {
        return new GenericSelector<RemoteApplicationEvent>(){

            public boolean accept(RemoteApplicationEvent source) {
                return BusAutoConfiguration.this.serviceMatcher().isFromSelf(source);
            }
        };
    }

    private ApplicationEventListeningMessageProducer cloudBusOutboundMessageProducer() {
        ApplicationEventListeningMessageProducer producer = new ApplicationEventListeningMessageProducer();
        producer.setEventTypes(new Class[]{RemoteApplicationEvent.class});
        return producer;
    }

    @Bean
    public IntegrationFlow cloudBusOutboundFlow() {
        ApplicationEventListeningMessageProducer producer = this.cloudBusOutboundMessageProducer();
        this.context.addApplicationListener((ApplicationListener)producer);
        return ((IntegrationFlowBuilder)((IntegrationFlowBuilder)IntegrationFlows.from((MessageProducerSupport)producer).filter(this.outboundFilter())).channel((MessageChannel)this.cloudBusOutboundChannel())).get();
    }

    @Bean
    public MessageChannel cloudBusInboundChannel() {
        return new DirectChannel();
    }

    @Bean
    public GenericSelector<?> inboundFilter() {
        return new GenericSelector<RemoteApplicationEvent>(){

            public boolean accept(RemoteApplicationEvent event) {
                return !BusAutoConfiguration.this.serviceMatcher().isFromSelf(event) && BusAutoConfiguration.this.serviceMatcher().isForSelf(event);
            }
        };
    }

    @Bean
    public IntegrationFlow cloudBusInboundFlow() {
        ApplicationEventPublishingMessageHandler messageHandler = new ApplicationEventPublishingMessageHandler();
        return ((IntegrationFlowBuilder)((IntegrationFlowBuilder)IntegrationFlows.from((MessageChannel)this.cloudBusInboundChannel()).filter(this.inboundFilter())).handle((MessageHandler)messageHandler)).get();
    }

    @Bean
    @GlobalChannelInterceptor(patterns={"cloudBusInboundFlow*"})
    public WireTap wireTap() {
        return new WireTap((MessageChannel)this.cloudBusWiretapChannel());
    }

    @Bean
    public DirectChannel cloudBusWiretapChannel() {
        return (DirectChannel)MessageChannels.direct().get();
    }

    @Bean
    public IntegrationFlow loggingFlow() {
        LoggingHandler handler = new LoggingHandler("INFO");
        handler.setShouldLogFullMessage(true);
        return ((IntegrationFlowBuilder)IntegrationFlows.from((MessageChannel)this.cloudBusWiretapChannel()).handle((MessageHandler)handler)).get();
    }

    @Bean
    public PathMatcher busPathMatcher() {
        return new AntPathMatcher(":");
    }

    @Bean
    public ServiceMatcher serviceMatcher() {
        return new ServiceMatcher();
    }

    @Configuration
    @ConditionalOnClass(value={EnvironmentManager.class})
    @ConditionalOnBean(value={EnvironmentManager.class})
    protected static class BusEnvironmentConfiguration {
        protected BusEnvironmentConfiguration() {
        }

        @Bean
        @ConditionalOnProperty(value={"spring.cloud.bus.env.enabled"}, matchIfMissing=true)
        public EnvironmentChangeListener environmentChangeListener() {
            return new EnvironmentChangeListener();
        }

        @Configuration
        @ConditionalOnClass(value={Endpoint.class})
        @ConditionalOnProperty(value={"endpoints.spring.cloud.bus.env.enabled"}, matchIfMissing=true)
        protected static class EnvironmentBusEndpointConfiguration {
            protected EnvironmentBusEndpointConfiguration() {
            }

            @Bean
            public EnvironmentBusEndpoint environmentBusEndpoint(ApplicationContext context, BusEndpoint busEndpoint) {
                return new EnvironmentBusEndpoint((ApplicationEventPublisher)context, context.getId(), busEndpoint);
            }
        }
    }

    @Configuration
    @ConditionalOnClass(value={Endpoint.class, RefreshScope.class})
    @ConditionalOnBean(value={RefreshEndpoint.class})
    protected static class BusRefreshConfiguration {
        protected BusRefreshConfiguration() {
        }

        @Bean
        @ConditionalOnProperty(value={"spring.cloud.bus.refresh.enabled"}, matchIfMissing=true)
        public RefreshListener refreshListener(RefreshEndpoint refreshEndpoint) {
            return new RefreshListener(refreshEndpoint);
        }

        @Configuration
        @ConditionalOnProperty(value={"endpoints.spring.cloud.bus.refresh.enabled"}, matchIfMissing=true)
        protected static class BusRefreshEndpointConfiguration {
            protected BusRefreshEndpointConfiguration() {
            }

            @Bean
            public RefreshBusEndpoint refreshBusEndpoint(ApplicationContext context, BusEndpoint busEndpoint) {
                return new RefreshBusEndpoint((ApplicationEventPublisher)context, context.getId(), busEndpoint);
            }
        }
    }

    @Configuration
    @ConditionalOnClass(value={Endpoint.class})
    protected static class BusEndpointConfiguration {
        protected BusEndpointConfiguration() {
        }

        @Bean
        public BusEndpoint busEndpoint() {
            return new BusEndpoint();
        }
    }
}

