/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.cloudfoundry;

import org.cloudfoundry.client.CloudFoundryClient;
import org.cloudfoundry.doppler.DopplerClient;
import org.cloudfoundry.operations.CloudFoundryOperations;
import org.cloudfoundry.operations.DefaultCloudFoundryOperations;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.DefaultConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import org.cloudfoundry.reactor.client.ReactorCloudFoundryClient;
import org.cloudfoundry.reactor.doppler.ReactorDopplerClient;
import org.cloudfoundry.reactor.routing.ReactorRoutingClient;
import org.cloudfoundry.reactor.tokenprovider.PasswordGrantTokenProvider;
import org.cloudfoundry.reactor.uaa.ReactorUaaClient;
import org.cloudfoundry.routing.RoutingClient;
import org.cloudfoundry.uaa.UaaClient;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.cloudfoundry.CloudFoundryProperties;
import org.springframework.cloud.cloudfoundry.CloudFoundryService;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(prefix="spring.cloud.cloudfoundry", name={"username", "password"})
@ConditionalOnClass(name={"reactor.core.publisher.Flux", "org.cloudfoundry.operations.DefaultCloudFoundryOperations", "org.cloudfoundry.reactor.client.ReactorCloudFoundryClient", "org.reactivestreams.Publisher"})
@EnableConfigurationProperties(value={CloudFoundryProperties.class})
public class CloudFoundryClientAutoConfiguration {
    private final CloudFoundryProperties cloudFoundryProperties;

    public CloudFoundryClientAutoConfiguration(CloudFoundryProperties cfp) {
        this.cloudFoundryProperties = cfp;
    }

    @Bean
    @Lazy
    @ConditionalOnMissingBean
    public CloudFoundryService cloudFoundryService(CloudFoundryOperations cloudFoundryOperations) {
        return new CloudFoundryService(cloudFoundryOperations);
    }

    @Bean
    @Lazy
    @ConditionalOnMissingBean
    public DefaultCloudFoundryOperations cloudFoundryOperations(CloudFoundryClient cloudFoundryClient, DopplerClient dopplerClient, RoutingClient routingClient, UaaClient uaaClient) {
        String organization = this.cloudFoundryProperties.getOrg();
        String space = this.cloudFoundryProperties.getSpace();
        return DefaultCloudFoundryOperations.builder().cloudFoundryClient(cloudFoundryClient).dopplerClient(dopplerClient).routingClient(routingClient).uaaClient(uaaClient).organization(organization).space(space).build();
    }

    @Bean
    @Lazy
    @ConditionalOnMissingBean
    public ReactorCloudFoundryClient cloudFoundryClient(ConnectionContext connectionContext, TokenProvider tokenProvider) {
        return ReactorCloudFoundryClient.builder().connectionContext(connectionContext).tokenProvider(tokenProvider).build();
    }

    @Bean
    @Lazy
    @ConditionalOnMissingBean
    public DopplerClient dopplerClient(ConnectionContext connectionContext, TokenProvider tokenProvider) {
        return ReactorDopplerClient.builder().connectionContext(connectionContext).tokenProvider(tokenProvider).build();
    }

    @Bean
    @Lazy
    @ConditionalOnMissingBean
    public RoutingClient routingClient(ConnectionContext connectionContext, TokenProvider tokenProvider) {
        return ReactorRoutingClient.builder().connectionContext(connectionContext).tokenProvider(tokenProvider).build();
    }

    @Bean
    @Lazy
    @ConditionalOnMissingBean
    public ReactorUaaClient uaaClient(ConnectionContext connectionContext, TokenProvider tokenProvider) {
        return ReactorUaaClient.builder().connectionContext(connectionContext).tokenProvider(tokenProvider).build();
    }

    @Bean
    @Lazy
    @ConditionalOnMissingBean
    public DefaultConnectionContext connectionContext() {
        String apiHost = this.cloudFoundryProperties.getUrl();
        Boolean skipSslValidation = this.cloudFoundryProperties.isSkipSslValidation();
        return DefaultConnectionContext.builder().apiHost(apiHost).skipSslValidation(skipSslValidation.booleanValue()).build();
    }

    @Bean
    @Lazy
    @ConditionalOnMissingBean
    public PasswordGrantTokenProvider tokenProvider() {
        String username = this.cloudFoundryProperties.getUsername();
        String password = this.cloudFoundryProperties.getPassword();
        return PasswordGrantTokenProvider.builder().password(password).username(username).build();
    }
}

