/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.cloudfoundry;

import java.util.Map;
import org.springframework.cloud.cloudfoundry.CloudFoundryServiceInfoCreator;
import org.springframework.cloud.cloudfoundry.Tags;
import org.springframework.cloud.service.common.RelationalServiceInfo;
import org.springframework.cloud.util.UriInfo;

public abstract class RelationalServiceInfoCreator<SI extends RelationalServiceInfo>
extends CloudFoundryServiceInfoCreator<SI> {
    public RelationalServiceInfoCreator(Tags tags, String uriScheme) {
        super(tags, uriScheme);
    }

    public abstract SI createServiceInfo(String var1, String var2);

    public SI createServiceInfo(Map<String, Object> serviceData) {
        Map credentials = (Map)serviceData.get("credentials");
        String id = (String)serviceData.get("name");
        String uri = this.getStringFromCredentials(credentials, "uri", "url");
        if (uri == null) {
            String host = this.getStringFromCredentials(credentials, "hostname", "host");
            int port = Integer.parseInt(credentials.get("port").toString());
            String username = this.getStringFromCredentials(credentials, "user", "username");
            String password = (String)credentials.get("password");
            String database = (String)credentials.get("name");
            uri = new UriInfo(this.getUriScheme(), host, port, username, password, database).toString();
        }
        return this.createServiceInfo(id, uri);
    }
}

