/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.discovery.health;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.event.InstanceRegisteredEvent;
import org.springframework.cloud.client.discovery.health.DiscoveryClientHealthIndicatorProperties;
import org.springframework.cloud.client.discovery.health.DiscoveryHealthIndicator;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;

public class DiscoveryClientHealthIndicator
implements DiscoveryHealthIndicator,
Ordered,
ApplicationListener<InstanceRegisteredEvent<?>> {
    private AtomicBoolean discoveryInitialized = new AtomicBoolean(false);
    private int order = Integer.MIN_VALUE;
    private final DiscoveryClient discoveryClient;
    private final DiscoveryClientHealthIndicatorProperties properties;
    private final Log log = LogFactory.getLog(DiscoveryClientHealthIndicator.class);

    @Deprecated
    public DiscoveryClientHealthIndicator(DiscoveryClient discoveryClient) {
        this(discoveryClient, new DiscoveryClientHealthIndicatorProperties());
    }

    public DiscoveryClientHealthIndicator(DiscoveryClient discoveryClient, DiscoveryClientHealthIndicatorProperties properties) {
        this.discoveryClient = discoveryClient;
        this.properties = properties;
    }

    public void onApplicationEvent(InstanceRegisteredEvent<?> event) {
        if (this.discoveryInitialized.compareAndSet(false, true)) {
            this.log.debug((Object)"Discovery Client has been initialized");
        }
    }

    @Override
    public Health health() {
        Health.Builder builder = new Health.Builder();
        if (this.discoveryInitialized.get()) {
            try {
                List<String> services = this.discoveryClient.getServices();
                String description = this.properties.isIncludeDescription() ? this.discoveryClient.description() : "";
                builder.status(new Status("UP", description)).withDetail("services", services);
            }
            catch (Exception e) {
                this.log.error((Object)"Error", (Throwable)e);
                builder.down(e);
            }
        } else {
            builder.status(new Status(Status.UNKNOWN.getCode(), "Discovery Client not initialized"));
        }
        return builder.build();
    }

    @Override
    public String getName() {
        return "discoveryClient";
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }
}

