/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.autoconfigure;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.EndpointAutoConfiguration;
import org.springframework.boot.actuate.endpoint.Endpoint;
import org.springframework.boot.actuate.endpoint.EnvironmentEndpoint;
import org.springframework.boot.actuate.endpoint.mvc.MvcEndpoint;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.WebMvcAutoConfiguration;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;
import org.springframework.cloud.config.client.RefreshEndpoint;
import org.springframework.cloud.context.environment.EnvironmentManager;
import org.springframework.cloud.context.environment.EnvironmentManagerMvcEndpoint;
import org.springframework.cloud.context.restart.RestartEndpoint;
import org.springframework.cloud.context.restart.RestartMvcEndpoint;
import org.springframework.cloud.endpoint.GenericPostableMvcEndpoint;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={EnvironmentEndpoint.class})
@ConditionalOnProperty(value={"endpoints.env.enabled"}, matchIfMissing=true)
@ConditionalOnWebApplication
@ConditionalOnBean(value={RestartEndpoint.class})
@AutoConfigureAfter(value={WebMvcAutoConfiguration.class, EndpointAutoConfiguration.class, RefreshAutoConfiguration.class})
public class LifecycleMvcEndpointAutoConfiguration {
    @Autowired
    private RestartEndpoint restartEndpoint;

    @Bean
    @ConditionalOnBean(value={EnvironmentEndpoint.class})
    public EnvironmentManagerMvcEndpoint environmentManagerEndpoint(EnvironmentEndpoint delegate, EnvironmentManager environment) {
        return new EnvironmentManagerMvcEndpoint(delegate, environment);
    }

    @Bean
    @ConditionalOnBean(value={RefreshEndpoint.class})
    public MvcEndpoint refreshMvcEndpoint(RefreshEndpoint endpoint) {
        return new GenericPostableMvcEndpoint((Endpoint<?>)endpoint);
    }

    @Bean
    public RestartMvcEndpoint restartMvcEndpoint() {
        return new RestartMvcEndpoint(this.restartEndpoint);
    }

    @Bean
    public MvcEndpoint pauseMvcEndpoint(RestartMvcEndpoint restartEndpoint) {
        return restartEndpoint.getPauseEndpoint();
    }

    @Bean
    public MvcEndpoint resumeMvcEndpoint(RestartMvcEndpoint restartEndpoint) {
        return restartEndpoint.getResumeEndpoint();
    }
}

