/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bootstrap.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.bind.PropertySourcesPropertyValues;
import org.springframework.boot.bind.RelaxedDataBinder;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.bootstrap.config.PropertySourceBootstrapProperties;
import org.springframework.cloud.config.client.ConfigClientProperties;
import org.springframework.cloud.config.client.ConfigServicePropertySourceLocator;
import org.springframework.cloud.config.client.PropertySourceLocator;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.cloud.logging.LoggingRebinder;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;

@Configuration
@EnableConfigurationProperties(value={PropertySourceBootstrapProperties.class})
public class PropertySourceBootstrapConfiguration
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    private static final String BOOTSTRAP_PROPERTY_SOURCE_NAME = "bootstrap";
    private static Log logger = LogFactory.getLog(PropertySourceBootstrapConfiguration.class);
    @Autowired(required=false)
    private List<PropertySourceLocator> propertySourceLocators = new ArrayList<PropertySourceLocator>();
    @Autowired
    private PropertySourceBootstrapProperties properties;

    public void setPropertySourceLocators(Collection<PropertySourceLocator> propertySourceLocators) {
        this.propertySourceLocators = new ArrayList<PropertySourceLocator>(propertySourceLocators);
    }

    public void initialize(ConfigurableApplicationContext applicationContext) {
        CompositePropertySource composite = new CompositePropertySource(BOOTSTRAP_PROPERTY_SOURCE_NAME);
        AnnotationAwareOrderComparator.sort(this.propertySourceLocators);
        boolean empty = true;
        for (PropertySourceLocator locator : this.propertySourceLocators) {
            PropertySource<?> source = null;
            source = locator.locate((Environment)applicationContext.getEnvironment());
            if (source == null) continue;
            logger.info((Object)("Located property source: " + source));
            composite.addPropertySource(source);
            empty = false;
        }
        if (!empty) {
            MutablePropertySources propertySources = applicationContext.getEnvironment().getPropertySources();
            if (propertySources.contains(BOOTSTRAP_PROPERTY_SOURCE_NAME)) {
                propertySources.remove(BOOTSTRAP_PROPERTY_SOURCE_NAME);
            }
            this.insertPropertySources(propertySources, composite);
            this.setLogLevels(applicationContext.getEnvironment());
        }
    }

    private void setLogLevels(ConfigurableEnvironment environment) {
        LoggingRebinder rebinder = new LoggingRebinder();
        rebinder.setEnvironment((Environment)environment);
        rebinder.onApplicationEvent(new EnvironmentChangeEvent(Collections.emptySet()));
    }

    private void insertPropertySources(MutablePropertySources propertySources, CompositePropertySource composite) {
        MutablePropertySources incoming = new MutablePropertySources();
        incoming.addFirst((PropertySource)composite);
        PropertySourceBootstrapProperties remoteProperties = new PropertySourceBootstrapProperties();
        new RelaxedDataBinder((Object)remoteProperties, "spring.cloud.config").bind((PropertyValues)new PropertySourcesPropertyValues((PropertySources)incoming));
        if (!remoteProperties.isAllowOverride() || remoteProperties.isOverrideSystemProperties()) {
            propertySources.addFirst((PropertySource)composite);
            return;
        }
        if (propertySources.contains("systemEnvironment")) {
            propertySources.addAfter("systemEnvironment", (PropertySource)composite);
        } else {
            propertySources.addLast((PropertySource)composite);
        }
    }

    @Configuration
    @ConditionalOnProperty(value={"spring.cloud.config.enabled"}, matchIfMissing=true)
    protected static class PropertySourceLocatorConfiguration {
        @Autowired
        private ConfigurableEnvironment environment;

        protected PropertySourceLocatorConfiguration() {
        }

        @Bean
        public ConfigClientProperties configClientProperties() {
            ConfigClientProperties client = new ConfigClientProperties((Environment)this.environment);
            return client;
        }

        @Bean
        public ConfigServicePropertySourceLocator configServicePropertySource() {
            ConfigServicePropertySourceLocator locator = new ConfigServicePropertySourceLocator(this.configClientProperties());
            return locator;
        }
    }
}

