/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.client;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.boot.actuate.endpoint.AbstractEndpoint;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.cloud.context.scope.refresh.RefreshScope;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;

@ConfigurationProperties(prefix="endpoints.refresh", ignoreUnknownFields=false)
@ManagedResource
public class RefreshEndpoint
extends AbstractEndpoint<Collection<String>> {
    private Set<String> standardSources = new HashSet<String>(Arrays.asList("systemProperties", "systemEnvironment", "jndiProperties", "servletConfigInitParams", "servletContextInitParams"));
    private ConfigurableApplicationContext context;
    private RefreshScope scope;

    public RefreshEndpoint(ConfigurableApplicationContext context, RefreshScope scope) {
        super("refresh");
        this.context = context;
        this.scope = scope;
    }

    @ManagedOperation
    public synchronized String[] refresh() {
        Map<String, Object> before = this.extract(this.context.getEnvironment().getPropertySources());
        this.addConfigFilesToEnvironment();
        Set<String> keys = this.changes(before, this.extract(this.context.getEnvironment().getPropertySources())).keySet();
        this.scope.refreshAll();
        if (keys.isEmpty()) {
            return new String[0];
        }
        this.context.publishEvent((ApplicationEvent)new EnvironmentChangeEvent(keys));
        return keys.toArray(new String[keys.size()]);
    }

    private void addConfigFilesToEnvironment() {
        ConfigurableApplicationContext capture = new SpringApplicationBuilder(new Object[]{Empty.class}).showBanner(false).web(false).environment(this.context.getEnvironment()).run(new String[0]);
        MutablePropertySources target = this.context.getEnvironment().getPropertySources();
        for (PropertySource source : capture.getEnvironment().getPropertySources()) {
            String name = source.getName();
            if (this.standardSources.contains(name)) continue;
            if (target.contains(name)) {
                target.replace(name, source);
                continue;
            }
            if (target.contains("defaultProperties")) {
                target.addBefore("defaultProperties", source);
                continue;
            }
            target.addLast(source);
        }
    }

    public Collection<String> invoke() {
        return Arrays.asList(this.refresh());
    }

    private Map<String, Object> changes(Map<String, Object> before, Map<String, Object> after) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String key : before.keySet()) {
            if (!after.containsKey(key)) {
                result.put(key, null);
                continue;
            }
            if (this.equal(before.get(key), after.get(key))) continue;
            result.put(key, after.get(key));
        }
        for (String key : after.keySet()) {
            if (before.containsKey(key)) continue;
            result.put(key, after.get(key));
        }
        return result;
    }

    private boolean equal(Object one, Object two) {
        if (one == null && two == null) {
            return true;
        }
        if (one == null || two == null) {
            return false;
        }
        return one.equals(two);
    }

    private Map<String, Object> extract(MutablePropertySources propertySources) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (PropertySource parent : propertySources) {
            if (this.standardSources.contains(parent.getName())) continue;
            this.extract(parent, result);
        }
        return result;
    }

    private void extract(PropertySource<?> parent, Map<String, Object> result) {
        if (parent instanceof CompositePropertySource) {
            try {
                for (PropertySource source : ((CompositePropertySource)parent).getPropertySources()) {
                    this.extract(source, result);
                }
            }
            catch (Exception e) {
                return;
            }
        } else if (parent instanceof EnumerablePropertySource) {
            for (String key : ((EnumerablePropertySource)parent).getPropertyNames()) {
                result.put(key, parent.getProperty(key));
            }
        }
    }

    @Configuration
    protected static class Empty {
        protected Empty() {
        }
    }
}

