/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.monitor;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.cloud.config.monitor.BitbucketPropertyPathNotificationExtractor;
import org.springframework.cloud.config.monitor.CompositePropertyPathNotificationExtractor;
import org.springframework.cloud.config.monitor.FileMonitorConfiguration;
import org.springframework.cloud.config.monitor.GithubPropertyPathNotificationExtractor;
import org.springframework.cloud.config.monitor.GitlabPropertyPathNotificationExtractor;
import org.springframework.cloud.config.monitor.PropertyPathEndpoint;
import org.springframework.cloud.config.monitor.PropertyPathNotificationExtractor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@ConditionalOnWebApplication
@Import(value={FileMonitorConfiguration.class})
public class EnvironmentMonitorAutoConfiguration {
    @Autowired(required=false)
    private List<PropertyPathNotificationExtractor> extractors;

    @Bean
    public PropertyPathEndpoint propertyPathEndpoint() {
        return new PropertyPathEndpoint(new CompositePropertyPathNotificationExtractor(this.extractors));
    }

    @Bean
    @ConditionalOnProperty(value={"spring.cloud.config.server.monitor.github.enabled"}, havingValue="true", matchIfMissing=true)
    public GithubPropertyPathNotificationExtractor githubPropertyPathNotificationExtractor() {
        return new GithubPropertyPathNotificationExtractor();
    }

    @Bean
    @ConditionalOnProperty(value={"spring.cloud.config.server.monitor.gitlab.enabled"}, havingValue="true", matchIfMissing=true)
    public GitlabPropertyPathNotificationExtractor gitlabPropertyPathNotificationExtractor() {
        return new GitlabPropertyPathNotificationExtractor();
    }

    @Bean
    @ConditionalOnProperty(value={"spring.cloud.config.server.monitor.bitbucket.enabled"}, havingValue="true", matchIfMissing=true)
    public BitbucketPropertyPathNotificationExtractor bitbucketPropertyPathNotificationExtractor() {
        return new BitbucketPropertyPathNotificationExtractor();
    }
}

