/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server;

import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.server.JGitEnvironmentRepository;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.util.PatternMatchUtils;
import org.springframework.util.StringUtils;

@ConfigurationProperties(value="spring.cloud.config.server.git")
public class MultipleJGitEnvironmentRepository
extends JGitEnvironmentRepository {
    private Map<String, PatternMatchingJGitEnvironmentRepository> repos = new LinkedHashMap<String, PatternMatchingJGitEnvironmentRepository>();

    public MultipleJGitEnvironmentRepository(ConfigurableEnvironment environment) {
        super(environment);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        for (String name : this.repos.keySet()) {
            PatternMatchingJGitEnvironmentRepository repo = this.repos.get(name);
            repo.setEnvironment(this.getEnvironment());
            if (!StringUtils.hasText((String)repo.getName())) {
                repo.setName(name);
            }
            if (repo.getPattern() == null || repo.getPattern().length == 0) {
                repo.setPattern(new String[]{name});
            }
            repo.afterPropertiesSet();
        }
    }

    public void setRepos(Map<String, PatternMatchingJGitEnvironmentRepository> repos) {
        this.repos.putAll(repos);
    }

    public Map<String, PatternMatchingJGitEnvironmentRepository> getRepos() {
        return this.repos;
    }

    @Override
    public Environment findOne(String application, String profile, String label) {
        for (PatternMatchingJGitEnvironmentRepository repository : this.repos.values()) {
            Environment source = repository.findOne(application, profile, label);
            if (source == null) continue;
            return source;
        }
        return super.findOne(application, profile, label);
    }

    public static class PatternMatchingJGitEnvironmentRepository
    extends JGitEnvironmentRepository {
        private String[] pattern;
        private String name;

        public PatternMatchingJGitEnvironmentRepository() {
            super(null);
        }

        public PatternMatchingJGitEnvironmentRepository(String uri) {
            this();
            this.setUri(uri);
        }

        @Override
        public Environment findOne(String application, String profile, String label) {
            if (this.pattern == null || this.pattern.length == 0) {
                return null;
            }
            if (PatternMatchUtils.simpleMatch((String[])this.pattern, (String)application)) {
                return super.findOne(application, profile, label);
            }
            return null;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String[] getPattern() {
            return this.pattern;
        }

        public void setPattern(String[] pattern) {
            this.pattern = pattern;
        }
    }
}

