/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.config;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.cloud.config.server.config.ConfigServerProperties;
import org.springframework.cloud.config.server.encryption.EnvironmentEncryptor;
import org.springframework.cloud.config.server.environment.EnvironmentController;
import org.springframework.cloud.config.server.environment.EnvironmentEncryptorEnvironmentRepository;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.config.server.resource.ResourceController;
import org.springframework.cloud.config.server.resource.ResourceRepository;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.MediaType;
import org.springframework.web.servlet.config.annotation.ContentNegotiationConfigurer;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@ConditionalOnWebApplication
public class ConfigServerMvcConfiguration
extends WebMvcConfigurerAdapter {
    @Autowired
    private EnvironmentRepository repository;
    @Autowired
    private ResourceRepository resources;
    @Autowired
    private ConfigServerProperties server;
    @Autowired(required=false)
    private EnvironmentEncryptor environmentEncryptor;

    public void configureContentNegotiation(ContentNegotiationConfigurer configurer) {
        configurer.mediaType("properties", MediaType.valueOf((String)"text/plain"));
        configurer.mediaType("yml", MediaType.valueOf((String)"text/yaml"));
        configurer.mediaType("yaml", MediaType.valueOf((String)"text/yaml"));
    }

    @Bean
    public EnvironmentController environmentController() {
        EnvironmentController controller = new EnvironmentController(this.encrypted());
        controller.setStripDocumentFromYaml(this.server.isStripDocumentFromYaml());
        return controller;
    }

    @Bean
    public ResourceController resourceController() {
        ResourceController controller = new ResourceController(this.resources, this.encrypted());
        return controller;
    }

    private EnvironmentRepository encrypted() {
        EnvironmentEncryptorEnvironmentRepository encrypted = new EnvironmentEncryptorEnvironmentRepository(this.repository, this.environmentEncryptor);
        encrypted.setOverrides(this.server.getOverrides());
        return encrypted;
    }
}

